/*
 * Licensed under BSD license.  See LICENCE.TXT  
 *
 * Produced by:	Jeff Lait
 *
 *      	7DRL Development
 *
 * NAME:        general.h ( 1812 Hunt Library, C++ )
 *
 * COMMENTS:
 *	Defines AI strategy!
 */

#pragma once

#include "vec2.h"
#include "glbdef.h"

class OVERMAP;
class MAP;

class GENERAL
{
public:
    GENERAL()
    { 
	reset();
    }

    void		reset()
    {
	myStrategy = STRATEGY_NONE; 
	myOrderDelay = 5; 		// Wait for map to build.
	myState = 0;
	memset(myWaypoints, 0, sizeof(IVEC2) * 10);
	memset(myDwellAtWaypoint, 0, sizeof(int) * 10);
	memset(myWaypointTimes, 0, sizeof(int) * 10);
    }

    void		runStrategy(int side, MAP *map);
    STRATEGY_NAMES	strategy() const { return myStrategy; }
    void		assignWaypoint(MAP *map, int side, int unit, int x, int y);
    void		assignWaypointIfNeeded(MAP *map, int side, int unit, int x, int y);

    IVEC2		waypoint(int idx) const { return myWaypoints[idx]; }
protected:
    bool		atWaypoint(int side, MAP *map, int unit) const;

    bool		unitDead(int side, MAP *map, int unit, int team) const;

    // Returns true if we've hit our goal.
    bool		marchFormationTo(int side, MAP *map,
				    int goalx, int goaly, int stride,
				    int dwell);

    bool		marchUnitTo(int side, MAP *map,
				    int unit,
				    int goalx, int goaly, int stride,
				    int dwell);

    void		updateDwellAtWaypoints(int side, MAP *map);
    void		resendWaypointOrders(int side, MAP *map);
    // My state;
    STRATEGY_NAMES			myStrategy;
    IVEC2				myWaypoints[10];
    int					myWaypointTimes[10];
    IVEC2				myFormation[10];
    int					myDwellAtWaypoint[10];
    int					myOrderDelay;
    int					myState;
};
