// Automatically generated by enummaker.py.
//DO NOT EDIT THIS FILE (Yes, I mean you!)
#ifndef __glbdef_h__
#define __glbdef_h__

#include "mygba.h"
#include "rand.h"
#include "buf.h"

inline BUF lcl_savedata(int data)
{
    BUF buf;
    buf.sprintf("%d", data);
    return buf;
}

inline BUF lcl_savedata(u8 data)
{
    BUF buf;
    buf.sprintf("%d", data);
    return buf;
}

inline BUF lcl_savedata(bool data)
{
    BUF buf;
    buf.sprintf("%s", data ? "true" : "false");
    return buf;
}

inline BUF lcl_savedata(const char *data)
{
    BUF buf;
    buf.reference(data);
    buf = buf.protectWithQuotes();
    return buf;
}

inline BUF lcl_savedata(const DICE &dice)
{
    BUF buf;
    buf.sprintf("%dd%d%+d", dice.myNumDie, dice.mySides, dice.myBonus);
    return buf;
}

inline void lcl_loaddata(BUF buf, int &data)
{
    data = atoi(buf.buffer());
}

inline void lcl_loaddata(BUF buf, u8 &data)
{
    if (buf.startsWith("'"))
    {
        data = buf.buffer()[1];
    }
    else
        data = atoi(buf.buffer());
}

inline void lcl_loaddata(BUF buf, bool &data)
{
    if (!buf.strcasecmp("true"))
        data = true;
    else if (!buf.strcasecmp("false"))
        data = false;
    else data = atoi(buf.buffer()) != 0;
}

inline void lcl_loaddata(BUF buf, const char *&data)
{
    // Leak!  Joyous Leaks!
    data = buf.strdup();
}

enum ORDER_NAMES
{
    ORDER_NONE,
    ORDER_WAIT,
    ORDER_MARCH,
    ORDER_FIRE,
    ORDER_FORMUP,

    NUM_ORDERS
};

#define FOREACH_ORDER(x) \
    for ((x) = (ORDER_NAMES) 0; \
         (x) < NUM_ORDERS; \
         (x) = (ORDER_NAMES) ((int)(x)+1))
enum STRATEGY_NAMES
{
    STRATEGY_NONE,
    STRATEGY_CHARGE,
    STRATEGY_PINCER,
    STRATEGY_LINE,
    STRATEGY_HOLDCENTER,
    STRATEGY_RESERVE,
    STRATEGY_PAIR,
    STRATEGY_FLANK,

    NUM_STRATEGYS
};

#define FOREACH_STRATEGY(x) \
    for ((x) = (STRATEGY_NAMES) 0; \
         (x) < NUM_STRATEGYS; \
         (x) = (STRATEGY_NAMES) ((int)(x)+1))
enum SOLDIER_NAMES
{
    SOLDIER_WAIT,
    SOLDIER_MARCH,
    SOLDIER_FIRE,
    SOLDIER_SENDMESSAGE,
    SOLDIER_RETURN,

    NUM_SOLDIERS
};

#define FOREACH_SOLDIER(x) \
    for ((x) = (SOLDIER_NAMES) 0; \
         (x) < NUM_SOLDIERS; \
         (x) = (SOLDIER_NAMES) ((int)(x)+1))
enum PHASE_NAMES
{
    PHASE_NORMAL,
    PHASE_FAST,
    PHASE_SLOW,
    PHASE_QUICK,

    NUM_PHASES
};

#define FOREACH_PHASE(x) \
    for ((x) = (PHASE_NAMES) 0; \
         (x) < NUM_PHASES; \
         (x) = (PHASE_NAMES) ((int)(x)+1))
enum EFFECTCLASS_NAMES
{
    EFFECTCLASS_NONE,
    EFFECTCLASS_HEAL,
    EFFECTCLASS_GAINMANA,
    EFFECTCLASS_LOSEMANA,
    EFFECTCLASS_GAINFOOD,
    EFFECTCLASS_LOSEFOOD,
    EFFECTCLASS_POISON,
    EFFECTCLASS_CURE,
    EFFECTCLASS_DAMAGE,
    EFFECTCLASS_RESIST,
    EFFECTCLASS_VULNERABLE,
    EFFECTCLASS_GAINITEM,

    NUM_EFFECTCLASSS
};

#define FOREACH_EFFECTCLASS(x) \
    for ((x) = (EFFECTCLASS_NAMES) 0; \
         (x) < NUM_EFFECTCLASSS; \
         (x) = (EFFECTCLASS_NAMES) ((int)(x)+1))
enum EFFECT_NAMES
{
    EFFECT_NONE,
    EFFECT_POTION_SPEED,
    EFFECT_POTION_HEAL,
    EFFECT_POTION_GREATERHEAL,
    EFFECT_POTION_FULLHEAL,
    EFFECT_POTION_ACIDVULN,
    EFFECT_POTION_ACIDRESIST,
    EFFECT_POTION_ACID,
    EFFECT_POTION_POISON,
    EFFECT_POTION_CURE,
    EFFECT_SPELL_HEAL,
    EFFECT_SPELL_HEAL_TI,
    EFFECT_SPELL_CREATEFOOD,
    EFFECT_SPELL_SMASH,
    EFFECT_SPELL_SMASH_TI,
    EFFECT_SPELL_BURN,
    EFFECT_SPELL_BURN_TI,
    EFFECT_SPELL_ZAP,
    EFFECT_SPELL_ZAP_TI,
    EFFECT_SPELL_POISON,
    EFFECT_SPELL_POISON_TI,
    EFFECT_SPELL_VULNFIRE,
    EFFECT_SPELL_VULNFIRE_TI,
    EFFECT_SPELL_VULNZAP,
    EFFECT_SPELL_VULNZAP_TI,
    EFFECT_SPELL_CURE,
    EFFECT_SPELL_RESISTFIRE,
    EFFECT_SPELL_RESISTFIRE_TI,
    EFFECT_SPELL_RESISTZAP,
    EFFECT_SPELL_RESISTZAP_TI,
    EFFECT_SPELL_SPEED,
    EFFECT_SPELL_SPEED_TI,
    EFFECT_SPELL_SLOW,
    EFFECT_SPELL_SLOW_TI,

    NUM_EFFECTS
};

#define FOREACH_EFFECT(x) \
    for ((x) = (EFFECT_NAMES) 0; \
         (x) < NUM_EFFECTS; \
         (x) = (EFFECT_NAMES) ((int)(x)+1))
enum ELEMENT_NAMES
{
    ELEMENT_NONE,
    ELEMENT_PHYSICAL,
    ELEMENT_POISON,
    ELEMENT_ACID,
    ELEMENT_LIGHT,
    ELEMENT_ELECTRICITY,
    ELEMENT_FIRE,
    ELEMENT_ICE,

    NUM_ELEMENTS
};

#define FOREACH_ELEMENT(x) \
    for ((x) = (ELEMENT_NAMES) 0; \
         (x) < NUM_ELEMENTS; \
         (x) = (ELEMENT_NAMES) ((int)(x)+1))
enum ATTACKSTYLE_NAMES
{
    ATTACKSTYLE_MELEE,
    ATTACKSTYLE_RANGE,
    ATTACKSTYLE_INTERNAL,

    NUM_ATTACKSTYLES
};

#define FOREACH_ATTACKSTYLE(x) \
    for ((x) = (ATTACKSTYLE_NAMES) 0; \
         (x) < NUM_ATTACKSTYLES; \
         (x) = (ATTACKSTYLE_NAMES) ((int)(x)+1))
enum ROOMTYPE_NAMES
{
    ROOMTYPE_NONE,
    ROOMTYPE_VILLAGE,
    ROOMTYPE_FACE,
    ROOMTYPE_ATRIUM,
    ROOMTYPE_CORRIDOR,
    ROOMTYPE_BARRACKS,
    ROOMTYPE_GUARDHOUSE,
    ROOMTYPE_THRONEROOM,
    ROOMTYPE_VAULT,
    ROOMTYPE_LIBRARY,
    ROOMTYPE_KITCHEN,
    ROOMTYPE_DININGROOM,
    ROOMTYPE_PANTRY,
    ROOMTYPE_ROGUE,
    ROOMTYPE_CAVE,
    ROOMTYPE_DARKCAVE,
    ROOMTYPE_MAZE,
    ROOMTYPE_BIGROOM,
    ROOMTYPE_WILDERNESS,

    NUM_ROOMTYPES
};

#define FOREACH_ROOMTYPE(x) \
    for ((x) = (ROOMTYPE_NAMES) 0; \
         (x) < NUM_ROOMTYPES; \
         (x) = (ROOMTYPE_NAMES) ((int)(x)+1))
enum LEVEL_NAMES
{
    LEVEL_NONE,

    NUM_LEVELS
};

#define FOREACH_LEVEL(x) \
    for ((x) = (LEVEL_NAMES) 0; \
         (x) < NUM_LEVELS; \
         (x) = (LEVEL_NAMES) ((int)(x)+1))
enum GAMERULES_NAMES
{
    GAMERULES_OFFICIAL,

    NUM_GAMERULESS
};

#define FOREACH_GAMERULES(x) \
    for ((x) = (GAMERULES_NAMES) 0; \
         (x) < NUM_GAMERULESS; \
         (x) = (GAMERULES_NAMES) ((int)(x)+1))
enum YELL_NAMES
{
    YELL_KEEPOUT,
    YELL_MURDERER,
    YELL_INVADER,
    YELL_KILL,
    YELL_KILLCHASE,
    YELL_LOCATION,
    YELL_HEARDLOCATION,
    YELL_TAUNT,
    YELL_VICTORY,
    YELL_RANGED,

    NUM_YELLS
};

#define FOREACH_YELL(x) \
    for ((x) = (YELL_NAMES) 0; \
         (x) < NUM_YELLS; \
         (x) = (YELL_NAMES) ((int)(x)+1))
enum OPTION_NAMES
{
    OPTION_INSTRUCTIONS,
    OPTION_WELCOME,
    OPTION_PLAY,
    OPTION_TOGGLEBULLETS,
    OPTION_AUTOPILOT,
    OPTION_FULLSCREEN,
    OPTION_ABOUT,
    OPTION_QUIT,

    NUM_OPTIONS
};

#define FOREACH_OPTION(x) \
    for ((x) = (OPTION_NAMES) 0; \
         (x) < NUM_OPTIONS; \
         (x) = (OPTION_NAMES) ((int)(x)+1))
enum ACTION_NAMES
{
    ACTION_NONE,
    ACTION_RESTART,
    ACTION_BUMP,
    ACTION_FIRE,
    ACTION_ROTATE,
    ACTION_REBOOTAVATAR,
    ACTION_DROP,
    ACTION_DROPALL,
    ACTION_DROPTOP,
    ACTION_BAGSHAKE,
    ACTION_BAGSWAPTOP,
    ACTION_BREAK,
    ACTION_BREAKTOP,
    ACTION_INSPECT,
    ACTION_QUAFF,
    ACTION_QUAFFTOP,
    ACTION_EAT,
    ACTION_EATTOP,
    ACTION_SUICIDE,
    ACTION_MEDITATE,
    ACTION_SEARCH,
    ACTION_WAIT,
    ACTION_WAITUNTIL,
    ACTION_STOPWAITING,
    ACTION_EXAMINE,
    ACTION_SAVE,
    ACTION_SHUTDOWN,
    ACTION_CREATEITEM,
    ACTION_CAST,
    ACTION_THROW,
    ACTION_THROWTOP,
    ACTION_WEAR,
    ACTION_WEARTOP,
    ACTION_CLIMB,
    ACTION_PICKUP,
    ACTION_TRANSMUTE,
    ACTION_ORDER,
    ACTION_MARK_QUEUE_EMPTY,
    ACTION_GHOSTMOVE,
    ACTION_GHOSTMOVEABS,
    ACTION_GHOSTRECENTER,

    NUM_ACTIONS
};

#define FOREACH_ACTION(x) \
    for ((x) = (ACTION_NAMES) 0; \
         (x) < NUM_ACTIONS; \
         (x) = (ACTION_NAMES) ((int)(x)+1))
enum GOSSIP_NAMES
{
    GOSSIP_INTRO,
    GOSSIP_MEDITATE,
    GOSSIP_EQUIP,

    NUM_GOSSIPS
};

#define FOREACH_GOSSIP(x) \
    for ((x) = (GOSSIP_NAMES) 0; \
         (x) < NUM_GOSSIPS; \
         (x) = (GOSSIP_NAMES) ((int)(x)+1))
enum ATTR_NAMES
{
    ATTR_NONE,
    ATTR_TERMINAL,
    ATTR_HEALTH,
    ATTR_MANA,
    ATTR_FOOD,
    ATTR_POWERBAR,
    ATTR_BORDER,
    ATTR_VICTORYBORDER,
    ATTR_DEATHBORDER,
    ATTR_DEATHBAR,
    ATTR_WAITBAR,
    ATTR_INVULNERABLE,
    ATTR_HILITE,
    ATTR_DKHILITE,
    ATTR_AVATARMEDITATE,
    ATTR_WAYPOINT,
    ATTR_LTWAYPOINT,
    ATTR_ELECTRICBLUE,
    ATTR_METAL,
    ATTR_BLUEPORTAL,
    ATTR_ORANGEPORTAL,
    ATTR_FIRE,
    ATTR_SEARCH,
    ATTR_GOLD,
    ATTR_YELLOW,
    ATTR_INV_YELLOW,
    ATTR_SHOUT,
    ATTR_EMOTE,
    ATTR_PINK,
    ATTR_PURPLE,
    ATTR_KOBOLD_ARCHER,
    ATTR_KOBOLD_MAGE,
    ATTR_KOBOLD_GUARD,
    ATTR_KOBOLD_BAKER,
    ATTR_NORMAL,
    ATTR_LIGHTBLACK,
    ATTR_OUTOFFOV,
    ATTR_WHITE,
    ATTR_INV_WHITE,
    ATTR_ORANGE,
    ATTR_DKORANGE,
    ATTR_INV_ORANGE,
    ATTR_LIGHTBROWN,
    ATTR_BROWN,
    ATTR_RED,
    ATTR_INV_RED,
    ATTR_DKRED,
    ATTR_GREEN,
    ATTR_INV_GREEN,
    ATTR_GREEN_ISLE,
    ATTR_DKGREEN,
    ATTR_DKRGREEN,
    ATTR_BLUE,
    ATTR_INV_BLUE,
    ATTR_LIGHTBLUE,
    ATTR_TEAL,
    ATTR_CYAN,
    ATTR_DKCYAN,
    ATTR_DKGREY,
    ATTR_GREY,
    ATTR_LTGREY,
    ATTR_PERCENT_SELECT,
    ATTR_PERCENT_HILIGHT,
    ATTR_PERCENT_SELECTHILIGHT,

    NUM_ATTRS
};

#define FOREACH_ATTR(x) \
    for ((x) = (ATTR_NAMES) 0; \
         (x) < NUM_ATTRS; \
         (x) = (ATTR_NAMES) ((int)(x)+1))
enum MAPFLAG_NAMES
{
    MAPFLAG_NONE = 0,
    MAPFLAG_FOV = 1,
    MAPFLAG_FOVCACHE = 2,
    MAPFLAG_PORTAL = 4,
    MAPFLAG_TRAP = 8,
    MAPFLAG_SEEN_PUSHER = 16,
    MAPFLAG_MOB = 32,
    MAPFLAG_ITEM = 64,

    NUM_MAPFLAGS
};

#define FOREACH_MAPFLAG(x) \
    for ((x) = (MAPFLAG_NAMES) 0; \
         (x) < NUM_MAPFLAGS; \
         (x) = (MAPFLAG_NAMES) ((int)(x)+1))
enum TRAP_NAMES
{
    TRAP_NONE,

    NUM_TRAPS
};

#define FOREACH_TRAP(x) \
    for ((x) = (TRAP_NAMES) 0; \
         (x) < NUM_TRAPS; \
         (x) = (TRAP_NAMES) ((int)(x)+1))
enum EVENTTYPE_NAMES
{
    EVENTTYPE_NONE = 0,
    EVENTTYPE_FORE = 1,
    EVENTTYPE_BACK = 2,
    EVENTTYPE_SYM = 4,
    EVENTTYPE_FORESYM = 5,
    EVENTTYPE_FOREBACK = 3,
    EVENTTYPE_ALL = 7,
    EVENTTYPE_SHOUT = 8,
    EVENTTYPE_LONG = 128,

    NUM_EVENTTYPES
};

#define FOREACH_EVENTTYPE(x) \
    for ((x) = (EVENTTYPE_NAMES) 0; \
         (x) < NUM_EVENTTYPES; \
         (x) = (EVENTTYPE_NAMES) ((int)(x)+1))
enum TILE_NAMES
{
    TILE_INVALID,
    TILE_NONE,
    TILE_PUSHER,
    TILE_STATUE,
    TILE_ALTAR,
    TILE_FLOOR,
    TILE_CAVEFLOOR,
    TILE_MAZEFLOOR,
    TILE_DARKCAVEFLOOR,
    TILE_CHAIR,
    TILE_TABLE,
    TILE_DOWNSTAIRS,
    TILE_UPSTAIRS,
    TILE_SNOWYPATH,
    TILE_PATH,
    TILE_GRASS,
    TILE_DIRT,
    TILE_MEDITATIONSPOT,
    TILE_FIELD,
    TILE_FROZENFIELD,
    TILE_FIRE,
    TILE_TUNNELWALL,
    TILE_WALL,
    TILE_MAZEWALL,
    TILE_CAVEWALL,
    TILE_FUTURE_FORGE,
    TILE_WOODWALL,
    TILE_SOLIDWALL,
    TILE_PORTAL,
    TILE_ORANGEPORTAL,
    TILE_BLUEPORTAL,
    TILE_MOUNTAINPROTOPORTAL,
    TILE_PROTOPORTAL,
    TILE_USERPROTOPORTAL,
    TILE_BROKENWALL,
    TILE_DOOR,
    TILE_MAZEDOOR,
    TILE_SECRETDOOR,
    TILE_MOUNTAIN,
    TILE_ICEMOUNTAIN,
    TILE_SNOWYPASS,
    TILE_BRIDGE,
    TILE_WATER,
    TILE_ICE,
    TILE_BUSH,
    TILE_FOREST,
    TILE_BAREFOREST,

    NUM_TILES
};

#define FOREACH_TILE(x) \
    for ((x) = (TILE_NAMES) 0; \
         (x) < NUM_TILES; \
         (x) = (TILE_NAMES) ((int)(x)+1))
enum TERRAIN_NAMES
{
    TERRAIN_NONE,
    TERRAIN_PLAINS,
    TERRAIN_BUSHES,
    TERRAIN_FOREST,
    TERRAIN_WASTE,

    NUM_TERRAINS
};

#define FOREACH_TERRAIN(x) \
    for ((x) = (TERRAIN_NAMES) 0; \
         (x) < NUM_TERRAINS; \
         (x) = (TERRAIN_NAMES) ((int)(x)+1))
enum AI_NAMES
{
    AI_NONE,
    AI_SOLDIER,
    AI_OFFICER,
    AI_STAYHOME,
    AI_HOME,
    AI_CHARGE,
    AI_RAT,
    AI_STRAIGHTLINE,
    AI_PATHTO,
    AI_ORTHO,
    AI_FLANK,
    AI_RANGECOWARD,
    AI_COWARD,
    AI_MOUSE,
    AI_PEACEFUL,
    AI_ADVENTURER,
    AI_ORC,

    NUM_AIS
};

#define FOREACH_AI(x) \
    for ((x) = (AI_NAMES) 0; \
         (x) < NUM_AIS; \
         (x) = (AI_NAMES) ((int)(x)+1))
enum DISTRIBUTION_NAMES
{
    DISTRIBUTION_CONSTANT,
    DISTRIBUTION_GAUSSIAN,
    DISTRIBUTION_UNIFORM,
    DISTRIBUTION_BIMODAL,

    NUM_DISTRIBUTIONS
};

#define FOREACH_DISTRIBUTION(x) \
    for ((x) = (DISTRIBUTION_NAMES) 0; \
         (x) < NUM_DISTRIBUTIONS; \
         (x) = (DISTRIBUTION_NAMES) ((int)(x)+1))
enum ATTACK_NAMES
{
    ATTACK_NONE,
    ATTACK_AVATAR,
    ATTACK_BAYONET,
    ATTACK_SWORD,
    ATTACK_BROKEN,
    ATTACK_EDGE,
    ATTACK_EDGE_WOOD,
    ATTACK_EDGE_METAL,
    ATTACK_EDGE_LIGHTMETAL,
    ATTACK_BLUNT,
    ATTACK_BLUNT_METAL,
    ATTACK_BLUNT_LIGHTMETAL,
    ATTACK_BLUNT_HEAVYMETAL,
    ATTACK_BLUNT_TI,
    ATTACK_POINT,
    ATTACK_POINT_METAL,
    ATTACK_POINT_HEAVYMETAL,
    ATTACK_POINT_LIGHTMETAL,

    NUM_ATTACKS
};

#define FOREACH_ATTACK(x) \
    for ((x) = (ATTACK_NAMES) 0; \
         (x) < NUM_ATTACKS; \
         (x) = (ATTACK_NAMES) ((int)(x)+1))
enum MOB_NAMES
{
    MOB_NONE,
    MOB_AVATAR,
    MOB_CYAN_OFFICER,
    MOB_CYAN_SOLDIER,
    MOB_ORANGE_OFFICER,
    MOB_ORANGE_SOLDIER,

    NUM_MOBS
};

#define FOREACH_MOB(x) \
    for ((x) = (MOB_NAMES) 0; \
         (x) < NUM_MOBS; \
         (x) = (MOB_NAMES) ((int)(x)+1))
enum ARMOURSLOT_NAMES
{
    ARMOURSLOT_NONE,

    NUM_ARMOURSLOTS
};

#define FOREACH_ARMOURSLOT(x) \
    for ((x) = (ARMOURSLOT_NAMES) 0; \
         (x) < NUM_ARMOURSLOTS; \
         (x) = (ARMOURSLOT_NAMES) ((int)(x)+1))
enum ITEMCLASS_NAMES
{
    ITEMCLASS_NONE,
    ITEMCLASS_MELEEWEAPON,
    ITEMCLASS_RANGEWEAPON,
    ITEMCLASS_ARMOUR,
    ITEMCLASS_POTION,
    ITEMCLASS_SPELLBOOK,
    ITEMCLASS_RING,
    ITEMCLASS_FOOD,
    ITEMCLASS_FURNITURE,

    NUM_ITEMCLASSS
};

#define FOREACH_ITEMCLASS(x) \
    for ((x) = (ITEMCLASS_NAMES) 0; \
         (x) < NUM_ITEMCLASSS; \
         (x) = (ITEMCLASS_NAMES) ((int)(x)+1))
enum ITEM_NAMES
{
    ITEM_NONE,
    ITEM_SLASH_WEAPON,
    ITEM_PIERCE_WEAPON,
    ITEM_BLUNT_WEAPON,
    ITEM_CHAIR,
    ITEM_TABLE,
    ITEM_SHELF,
    ITEM_BED,
    ITEM_STATUE,
    ITEM_MACGUFFIN,
    ITEM_CORPSE,
    ITEM_COIN,
    ITEM_QUICKBOOST,
    ITEM_HASTED,
    ITEM_BLIND,
    ITEM_ENRAGED,
    ITEM_POISON,
    ITEM_RESIST,
    ITEM_VULNERABLE,
    ITEM_PLAGUE,
    ITEM_SLOW,
    ITEM_INVULNERABLE,
    ITEM_SPELLBOOK_RED,
    ITEM_SPELLBOOK_GREEN,
    ITEM_SPELLBOOK_ORANGE,
    ITEM_SPELLBOOK_YELLOW,
    ITEM_SPELLBOOK_WHITE,
    ITEM_SPELLBOOK_GLOWING,
    ITEM_SPELLBOOK_CYAN,
    ITEM_SPELLBOOK_GREY,
    ITEM_SPELLBOOK_PURPLE,
    ITEM_POTION_RED,
    ITEM_POTION_YELLOW,
    ITEM_POTION_GREEN,
    ITEM_POTION_BLUE,
    ITEM_POTION_PURPLE,
    ITEM_POTION_WHITE,
    ITEM_POTION_GLOWING,
    ITEM_POTION_CYAN,

    NUM_ITEMS
};

#define FOREACH_ITEM(x) \
    for ((x) = (ITEM_NAMES) 0; \
         (x) < NUM_ITEMS; \
         (x) = (ITEM_NAMES) ((int)(x)+1))
enum SPELL_NAMES
{
    SPELL_NONE,

    NUM_SPELLS
};

#define FOREACH_SPELL(x) \
    for ((x) = (SPELL_NAMES) 0; \
         (x) < NUM_SPELLS; \
         (x) = (SPELL_NAMES) ((int)(x)+1))
enum RING_NAMES
{
    RING_NONE,

    NUM_RINGS
};

#define FOREACH_RING(x) \
    for ((x) = (RING_NAMES) 0; \
         (x) < NUM_RINGS; \
         (x) = (RING_NAMES) ((int)(x)+1))
enum POTION_NAMES
{
    POTION_NONE,
    POTION_SPEED,
    POTION_HEAL,
    POTION_GREATERHEAL,
    POTION_ACIDVULN,
    POTION_ACIDRESIST,
    POTION_ACID,
    POTION_POISON,
    POTION_CURE,

    NUM_POTIONS
};

#define FOREACH_POTION(x) \
    for ((x) = (POTION_NAMES) 0; \
         (x) < NUM_POTIONS; \
         (x) = (POTION_NAMES) ((int)(x)+1))
enum MATERIAL_NAMES
{
    MATERIAL_NONE,
    MATERIAL_WOOD,
    MATERIAL_STONE,
    MATERIAL_IRON,
    MATERIAL_SILVER,
    MATERIAL_STEEL,
    MATERIAL_GOLD,
    MATERIAL_ALUMINUM,
    MATERIAL_TITANIUM,

    NUM_MATERIALS
};

#define FOREACH_MATERIAL(x) \
    for ((x) = (MATERIAL_NAMES) 0; \
         (x) < NUM_MATERIALS; \
         (x) = (MATERIAL_NAMES) ((int)(x)+1))
enum KEY_NAMES
{
    KEY_MOVE_N,
    KEY_MOVE_NE,
    KEY_MOVE_NW,
    KEY_MOVE_S,
    KEY_MOVE_SE,
    KEY_MOVE_SW,
    KEY_MOVE_STAY,
    KEY_MOVE_E,
    KEY_MOVE_W,
    KEY_OVERMAPTOGGLE,
    KEY_SIMULATETOGGLE,
    KEY_WAYPOINT,
    KEY_TELESCOPE,
    KEY_RECENTER,
    KEY_SWITCHSIDE,

    NUM_KEYS
};

#define FOREACH_KEY(x) \
    for ((x) = (KEY_NAMES) 0; \
         (x) < NUM_KEYS; \
         (x) = (KEY_NAMES) ((int)(x)+1))
struct ORDER_DEF
{


    void reset()
    {

    }

    void saveData(ostream &os) const
    {

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);

            }
            else
                break;
        }
    }


};

extern const ORDER_DEF glb_orderdefs[];

struct STRATEGY_DEF
{
    const char * name;


    void reset()
    {
        name = "lemur";

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);

            }
            else
                break;
        }
    }


};

extern const STRATEGY_DEF glb_strategydefs[];

struct SOLDIER_DEF
{


    void reset()
    {

    }

    void saveData(ostream &os) const
    {

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);

            }
            else
                break;
        }
    }


};

extern const SOLDIER_DEF glb_soldierdefs[];

struct PHASE_DEF
{


    void reset()
    {

    }

    void saveData(ostream &os) const
    {

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);

            }
            else
                break;
        }
    }


};

extern const PHASE_DEF glb_phasedefs[];

struct EFFECTCLASS_DEF
{


    void reset()
    {

    }

    void saveData(ostream &os) const
    {

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);

            }
            else
                break;
        }
    }


};

extern const EFFECTCLASS_DEF glb_effectclassdefs[];

struct EFFECT_DEF
{
    int type;
    int element;
    int duration;
    int amount;
    int distribution;
    int itemflag;


    void reset()
    {
        type = EFFECTCLASS_NONE;
        element = ELEMENT_NONE;
        duration = 0;
        amount = 0;
        distribution = DISTRIBUTION_CONSTANT;
        itemflag = ITEM_NONE;

    }

    void saveData(ostream &os) const
    {
        os << "    type " << lcl_savedata(type).buffer() << "\n";
        os << "    element " << lcl_savedata(element).buffer() << "\n";
        os << "    duration " << lcl_savedata(duration).buffer() << "\n";
        os << "    amount " << lcl_savedata(amount).buffer() << "\n";
        os << "    distribution " << lcl_savedata(distribution).buffer() << "\n";
        os << "    itemflag " << lcl_savedata(itemflag).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("type"))
                    lcl_loaddata(_value, type);
                if (!_name.strcmp("element"))
                    lcl_loaddata(_value, element);
                if (!_name.strcmp("duration"))
                    lcl_loaddata(_value, duration);
                if (!_name.strcmp("amount"))
                    lcl_loaddata(_value, amount);
                if (!_name.strcmp("distribution"))
                    lcl_loaddata(_value, distribution);
                if (!_name.strcmp("itemflag"))
                    lcl_loaddata(_value, itemflag);

            }
            else
                break;
        }
    }


};

extern const EFFECT_DEF glb_effectdefs[];

struct ELEMENT_DEF
{
    const char * name;
    int attr;
    const char * damageverb;


    void reset()
    {
        name = "ether";
        attr = ATTR_CYAN;
        damageverb = "disintigrate";

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    attr " << lcl_savedata(attr).buffer() << "\n";
        os << "    damageverb " << lcl_savedata(damageverb).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("attr"))
                    lcl_loaddata(_value, attr);
                if (!_name.strcmp("damageverb"))
                    lcl_loaddata(_value, damageverb);

            }
            else
                break;
        }
    }


};

extern const ELEMENT_DEF glb_elementdefs[];

struct ATTACKSTYLE_DEF
{


    void reset()
    {

    }

    void saveData(ostream &os) const
    {

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);

            }
            else
                break;
        }
    }


};

extern const ATTACKSTYLE_DEF glb_attackstyledefs[];

struct ROOMTYPE_DEF
{
    const char * prefix;
    bool randomorient;
    bool allowportal;
    bool usegenerator;
    int wall_tile;
    int floor_tile;
    int path_tile;
    int door_tile;
    int tunnelwall_tile;
    const char * name;
    bool deadend;


    void reset()
    {
        prefix = "";
        randomorient = true;
        allowportal = true;
        usegenerator = false;
        wall_tile = TILE_WALL;
        floor_tile = TILE_FLOOR;
        path_tile = TILE_PATH;
        door_tile = TILE_DOOR;
        tunnelwall_tile = TILE_TUNNELWALL;
        name = "room";
        deadend = false;

    }

    void saveData(ostream &os) const
    {
        os << "    prefix " << lcl_savedata(prefix).buffer() << "\n";
        os << "    randomorient " << lcl_savedata(randomorient).buffer() << "\n";
        os << "    allowportal " << lcl_savedata(allowportal).buffer() << "\n";
        os << "    usegenerator " << lcl_savedata(usegenerator).buffer() << "\n";
        os << "    wall_tile " << lcl_savedata(wall_tile).buffer() << "\n";
        os << "    floor_tile " << lcl_savedata(floor_tile).buffer() << "\n";
        os << "    path_tile " << lcl_savedata(path_tile).buffer() << "\n";
        os << "    door_tile " << lcl_savedata(door_tile).buffer() << "\n";
        os << "    tunnelwall_tile " << lcl_savedata(tunnelwall_tile).buffer() << "\n";
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    deadend " << lcl_savedata(deadend).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("prefix"))
                    lcl_loaddata(_value, prefix);
                if (!_name.strcmp("randomorient"))
                    lcl_loaddata(_value, randomorient);
                if (!_name.strcmp("allowportal"))
                    lcl_loaddata(_value, allowportal);
                if (!_name.strcmp("usegenerator"))
                    lcl_loaddata(_value, usegenerator);
                if (!_name.strcmp("wall_tile"))
                    lcl_loaddata(_value, wall_tile);
                if (!_name.strcmp("floor_tile"))
                    lcl_loaddata(_value, floor_tile);
                if (!_name.strcmp("path_tile"))
                    lcl_loaddata(_value, path_tile);
                if (!_name.strcmp("door_tile"))
                    lcl_loaddata(_value, door_tile);
                if (!_name.strcmp("tunnelwall_tile"))
                    lcl_loaddata(_value, tunnelwall_tile);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("deadend"))
                    lcl_loaddata(_value, deadend);

            }
            else
                break;
        }
    }


};

extern const ROOMTYPE_DEF glb_roomtypedefs[];

struct LEVEL_DEF
{
    int numcreated;
    int roomtype;


    void reset()
    {
        numcreated = 0;
        roomtype = ROOMTYPE_ROGUE;

    }

    void saveData(ostream &os) const
    {
        os << "    numcreated " << lcl_savedata(numcreated).buffer() << "\n";
        os << "    roomtype " << lcl_savedata(roomtype).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("numcreated"))
                    lcl_loaddata(_value, numcreated);
                if (!_name.strcmp("roomtype"))
                    lcl_loaddata(_value, roomtype);

            }
            else
                break;
        }
    }


};

extern const LEVEL_DEF glb_leveldefs[];

struct GAMERULES_DEF
{
    int bosslevel;


    void reset()
    {
        bosslevel = 7;

    }

    void saveData(ostream &os) const
    {
        os << "    bosslevel " << lcl_savedata(bosslevel).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("bosslevel"))
                    lcl_loaddata(_value, bosslevel);

            }
            else
                break;
        }
    }


};

extern const GAMERULES_DEF glb_gamerulesdefs[];

struct YELL_DEF
{


    void reset()
    {

    }

    void saveData(ostream &os) const
    {

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);

            }
            else
                break;
        }
    }


};

extern const YELL_DEF glb_yelldefs[];

struct OPTION_DEF
{
    const char * name;


    void reset()
    {
        name = "None";

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);

            }
            else
                break;
        }
    }


};

extern const OPTION_DEF glb_optiondefs[];

struct ACTION_DEF
{


    void reset()
    {

    }

    void saveData(ostream &os) const
    {

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);

            }
            else
                break;
        }
    }


};

extern const ACTION_DEF glb_actiondefs[];

struct GOSSIP_DEF
{
    const char * name;


    void reset()
    {
        name = "none";

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);

            }
            else
                break;
        }
    }


};

extern const GOSSIP_DEF glb_gossipdefs[];

struct ATTR_DEF
{
    u8 bg_r;
    u8 bg_g;
    u8 bg_b;
    u8 fg_r;
    u8 fg_g;
    u8 fg_b;
    bool pulse;


    void reset()
    {
        bg_r = 0;
        bg_g = 0;
        bg_b = 0;
        fg_r = 255;
        fg_g = 255;
        fg_b = 255;
        pulse = false;

    }

    void saveData(ostream &os) const
    {
        os << "    bg_r " << lcl_savedata(bg_r).buffer() << "\n";
        os << "    bg_g " << lcl_savedata(bg_g).buffer() << "\n";
        os << "    bg_b " << lcl_savedata(bg_b).buffer() << "\n";
        os << "    fg_r " << lcl_savedata(fg_r).buffer() << "\n";
        os << "    fg_g " << lcl_savedata(fg_g).buffer() << "\n";
        os << "    fg_b " << lcl_savedata(fg_b).buffer() << "\n";
        os << "    pulse " << lcl_savedata(pulse).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("bg_r"))
                    lcl_loaddata(_value, bg_r);
                if (!_name.strcmp("bg_g"))
                    lcl_loaddata(_value, bg_g);
                if (!_name.strcmp("bg_b"))
                    lcl_loaddata(_value, bg_b);
                if (!_name.strcmp("fg_r"))
                    lcl_loaddata(_value, fg_r);
                if (!_name.strcmp("fg_g"))
                    lcl_loaddata(_value, fg_g);
                if (!_name.strcmp("fg_b"))
                    lcl_loaddata(_value, fg_b);
                if (!_name.strcmp("pulse"))
                    lcl_loaddata(_value, pulse);

            }
            else
                break;
        }
    }


};

extern const ATTR_DEF glb_attrdefs[];

struct MAPFLAG_DEF
{


    void reset()
    {

    }

    void saveData(ostream &os) const
    {

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);

            }
            else
                break;
        }
    }


};

extern const MAPFLAG_DEF glb_mapflagdefs[];

struct TRAP_DEF
{
    u8 sym;
    int attr;
    int element;
    const char * name;
    int item;


    void reset()
    {
        sym = '^';
        attr = ATTR_NORMAL;
        element = ELEMENT_PHYSICAL;
        name = "no-trap";
        item = ITEM_NONE;

    }

    void saveData(ostream &os) const
    {
        os << "    sym " << lcl_savedata(sym).buffer() << "\n";
        os << "    attr " << lcl_savedata(attr).buffer() << "\n";
        os << "    element " << lcl_savedata(element).buffer() << "\n";
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    item " << lcl_savedata(item).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("sym"))
                    lcl_loaddata(_value, sym);
                if (!_name.strcmp("attr"))
                    lcl_loaddata(_value, attr);
                if (!_name.strcmp("element"))
                    lcl_loaddata(_value, element);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("item"))
                    lcl_loaddata(_value, item);

            }
            else
                break;
        }
    }


};

extern const TRAP_DEF glb_trapdefs[];

struct EVENTTYPE_DEF
{


    void reset()
    {

    }

    void saveData(ostream &os) const
    {

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);

            }
            else
                break;
        }
    }


};

extern const EVENTTYPE_DEF glb_eventtypedefs[];

struct TILE_DEF
{
    u8 symbol;
    int attr;
    const char * legend;
    bool ispassable;
    bool istransparent;
    bool isphaseable;
    bool isdiggable;
    bool describe;
    bool semitransparent;
    bool forbidrandomwander;
    bool roomcolor;
    bool roomsymbol;


    void reset()
    {
        symbol = '&';
        attr = ATTR_NORMAL;
        legend = "none";
        ispassable = true;
        istransparent = true;
        isphaseable = true;
        isdiggable = false;
        describe = false;
        semitransparent = false;
        forbidrandomwander = false;
        roomcolor = false;
        roomsymbol = false;

    }

    void saveData(ostream &os) const
    {
        os << "    symbol " << lcl_savedata(symbol).buffer() << "\n";
        os << "    attr " << lcl_savedata(attr).buffer() << "\n";
        os << "    legend " << lcl_savedata(legend).buffer() << "\n";
        os << "    ispassable " << lcl_savedata(ispassable).buffer() << "\n";
        os << "    istransparent " << lcl_savedata(istransparent).buffer() << "\n";
        os << "    isphaseable " << lcl_savedata(isphaseable).buffer() << "\n";
        os << "    isdiggable " << lcl_savedata(isdiggable).buffer() << "\n";
        os << "    describe " << lcl_savedata(describe).buffer() << "\n";
        os << "    semitransparent " << lcl_savedata(semitransparent).buffer() << "\n";
        os << "    forbidrandomwander " << lcl_savedata(forbidrandomwander).buffer() << "\n";
        os << "    roomcolor " << lcl_savedata(roomcolor).buffer() << "\n";
        os << "    roomsymbol " << lcl_savedata(roomsymbol).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("symbol"))
                    lcl_loaddata(_value, symbol);
                if (!_name.strcmp("attr"))
                    lcl_loaddata(_value, attr);
                if (!_name.strcmp("legend"))
                    lcl_loaddata(_value, legend);
                if (!_name.strcmp("ispassable"))
                    lcl_loaddata(_value, ispassable);
                if (!_name.strcmp("istransparent"))
                    lcl_loaddata(_value, istransparent);
                if (!_name.strcmp("isphaseable"))
                    lcl_loaddata(_value, isphaseable);
                if (!_name.strcmp("isdiggable"))
                    lcl_loaddata(_value, isdiggable);
                if (!_name.strcmp("describe"))
                    lcl_loaddata(_value, describe);
                if (!_name.strcmp("semitransparent"))
                    lcl_loaddata(_value, semitransparent);
                if (!_name.strcmp("forbidrandomwander"))
                    lcl_loaddata(_value, forbidrandomwander);
                if (!_name.strcmp("roomcolor"))
                    lcl_loaddata(_value, roomcolor);
                if (!_name.strcmp("roomsymbol"))
                    lcl_loaddata(_value, roomsymbol);

            }
            else
                break;
        }
    }


};

extern const TILE_DEF glb_tiledefs[];

struct TERRAIN_DEF
{
    int tile;
    u8 grass;
    u8 dirt;
    u8 bush;
    u8 tree;
    int sightrange;
    int armyrange;


    void reset()
    {
        tile = TILE_NONE;
        grass = 0;
        dirt = 0;
        bush = 0;
        tree = 0;
        sightrange = 30;
        armyrange = 500;

    }

    void saveData(ostream &os) const
    {
        os << "    tile " << lcl_savedata(tile).buffer() << "\n";
        os << "    grass " << lcl_savedata(grass).buffer() << "\n";
        os << "    dirt " << lcl_savedata(dirt).buffer() << "\n";
        os << "    bush " << lcl_savedata(bush).buffer() << "\n";
        os << "    tree " << lcl_savedata(tree).buffer() << "\n";
        os << "    sightrange " << lcl_savedata(sightrange).buffer() << "\n";
        os << "    armyrange " << lcl_savedata(armyrange).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("tile"))
                    lcl_loaddata(_value, tile);
                if (!_name.strcmp("grass"))
                    lcl_loaddata(_value, grass);
                if (!_name.strcmp("dirt"))
                    lcl_loaddata(_value, dirt);
                if (!_name.strcmp("bush"))
                    lcl_loaddata(_value, bush);
                if (!_name.strcmp("tree"))
                    lcl_loaddata(_value, tree);
                if (!_name.strcmp("sightrange"))
                    lcl_loaddata(_value, sightrange);
                if (!_name.strcmp("armyrange"))
                    lcl_loaddata(_value, armyrange);

            }
            else
                break;
        }
    }


};

extern const TERRAIN_DEF glb_terraindefs[];

struct AI_DEF
{
    const char * name;
    const char * descr;


    void reset()
    {
        name = "brainless";
        descr = "They are known to wander aimlessly about.";

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    descr " << lcl_savedata(descr).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("descr"))
                    lcl_loaddata(_value, descr);

            }
            else
                break;
        }
    }


};

extern const AI_DEF glb_aidefs[];

struct DISTRIBUTION_DEF
{
    const char * name;
    const char * descr;


    void reset()
    {
        name = "none";
        descr = "none";

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    descr " << lcl_savedata(descr).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("descr"))
                    lcl_loaddata(_value, descr);

            }
            else
                break;
        }
    }


};

extern const DISTRIBUTION_DEF glb_distributiondefs[];

struct ATTACK_DEF
{
    const char * verb;
    const char * noun;
    int effect;
    int element;
    int damage;
    int chancebonus;
    int distribution;


    void reset()
    {
        verb = "attack";
        noun = "attack";
        effect = EFFECT_NONE;
        element = ELEMENT_PHYSICAL;
        damage = 1;
        chancebonus = 0;
        distribution = DISTRIBUTION_UNIFORM;

    }

    void saveData(ostream &os) const
    {
        os << "    verb " << lcl_savedata(verb).buffer() << "\n";
        os << "    noun " << lcl_savedata(noun).buffer() << "\n";
        os << "    effect " << lcl_savedata(effect).buffer() << "\n";
        os << "    element " << lcl_savedata(element).buffer() << "\n";
        os << "    damage " << lcl_savedata(damage).buffer() << "\n";
        os << "    chancebonus " << lcl_savedata(chancebonus).buffer() << "\n";
        os << "    distribution " << lcl_savedata(distribution).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("verb"))
                    lcl_loaddata(_value, verb);
                if (!_name.strcmp("noun"))
                    lcl_loaddata(_value, noun);
                if (!_name.strcmp("effect"))
                    lcl_loaddata(_value, effect);
                if (!_name.strcmp("element"))
                    lcl_loaddata(_value, element);
                if (!_name.strcmp("damage"))
                    lcl_loaddata(_value, damage);
                if (!_name.strcmp("chancebonus"))
                    lcl_loaddata(_value, chancebonus);
                if (!_name.strcmp("distribution"))
                    lcl_loaddata(_value, distribution);

            }
            else
                break;
        }
    }


};

extern const ATTACK_DEF glb_attackdefs[];

struct MOB_DEF
{
    u8 symbol;
    int attr;
    const char * name;
    const char * descr;
    bool isfriendly;
    int melee_attack;
    bool range_valid;
    int range_attack;
    int range_range;
    int range_recharge;
    u8 range_symbol;
    int range_attr;
    int max_hp;
    int max_mp;
    int damagereduction;
    int dodgebonus;
    int depth;
    u8 rarity;
    int ai;
    u8 corpsechance;
    int corpse_effect;
    int loot;
    int vulnerability;
    int resistance;
    bool isslow;
    bool isfast;
    bool isvampire;
    bool hidefromlos;
    bool isregenerate;
    bool passwall;
    bool candig;
    bool swallows;
    bool breeder;
    bool isthief;
    bool canleap;
    u8 sightrange;
    bool corrosiveblood;
    int totalkillsever;


    void reset()
    {
        symbol = '?';
        attr = ATTR_NORMAL;
        name = "unnamed";
        descr = "";
        isfriendly = false;
        melee_attack = ATTACK_NONE;
        range_valid = false;
        range_attack = ATTACK_NONE;
        range_range = 0;
        range_recharge = 4;
        range_symbol = '*';
        range_attr = ATTR_NORMAL;
        max_hp = 1;
        max_mp = 0;
        damagereduction = 0;
        dodgebonus = 0;
        depth = 0;
        rarity = 100;
        ai = AI_CHARGE;
        corpsechance = 100;
        corpse_effect = EFFECT_NONE;
        loot = -1;
        vulnerability = ELEMENT_NONE;
        resistance = ELEMENT_NONE;
        isslow = false;
        isfast = false;
        isvampire = false;
        hidefromlos = false;
        isregenerate = false;
        passwall = false;
        candig = false;
        swallows = false;
        breeder = false;
        isthief = false;
        canleap = false;
        sightrange = 100;
        corrosiveblood = false;
        totalkillsever = 0;

    }

    void saveData(ostream &os) const
    {
        os << "    symbol " << lcl_savedata(symbol).buffer() << "\n";
        os << "    attr " << lcl_savedata(attr).buffer() << "\n";
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    descr " << lcl_savedata(descr).buffer() << "\n";
        os << "    isfriendly " << lcl_savedata(isfriendly).buffer() << "\n";
        os << "    melee_attack " << lcl_savedata(melee_attack).buffer() << "\n";
        os << "    range_valid " << lcl_savedata(range_valid).buffer() << "\n";
        os << "    range_attack " << lcl_savedata(range_attack).buffer() << "\n";
        os << "    range_range " << lcl_savedata(range_range).buffer() << "\n";
        os << "    range_recharge " << lcl_savedata(range_recharge).buffer() << "\n";
        os << "    range_symbol " << lcl_savedata(range_symbol).buffer() << "\n";
        os << "    range_attr " << lcl_savedata(range_attr).buffer() << "\n";
        os << "    max_hp " << lcl_savedata(max_hp).buffer() << "\n";
        os << "    max_mp " << lcl_savedata(max_mp).buffer() << "\n";
        os << "    damagereduction " << lcl_savedata(damagereduction).buffer() << "\n";
        os << "    dodgebonus " << lcl_savedata(dodgebonus).buffer() << "\n";
        os << "    depth " << lcl_savedata(depth).buffer() << "\n";
        os << "    rarity " << lcl_savedata(rarity).buffer() << "\n";
        os << "    ai " << lcl_savedata(ai).buffer() << "\n";
        os << "    corpsechance " << lcl_savedata(corpsechance).buffer() << "\n";
        os << "    corpse_effect " << lcl_savedata(corpse_effect).buffer() << "\n";
        os << "    loot " << lcl_savedata(loot).buffer() << "\n";
        os << "    vulnerability " << lcl_savedata(vulnerability).buffer() << "\n";
        os << "    resistance " << lcl_savedata(resistance).buffer() << "\n";
        os << "    isslow " << lcl_savedata(isslow).buffer() << "\n";
        os << "    isfast " << lcl_savedata(isfast).buffer() << "\n";
        os << "    isvampire " << lcl_savedata(isvampire).buffer() << "\n";
        os << "    hidefromlos " << lcl_savedata(hidefromlos).buffer() << "\n";
        os << "    isregenerate " << lcl_savedata(isregenerate).buffer() << "\n";
        os << "    passwall " << lcl_savedata(passwall).buffer() << "\n";
        os << "    candig " << lcl_savedata(candig).buffer() << "\n";
        os << "    swallows " << lcl_savedata(swallows).buffer() << "\n";
        os << "    breeder " << lcl_savedata(breeder).buffer() << "\n";
        os << "    isthief " << lcl_savedata(isthief).buffer() << "\n";
        os << "    canleap " << lcl_savedata(canleap).buffer() << "\n";
        os << "    sightrange " << lcl_savedata(sightrange).buffer() << "\n";
        os << "    corrosiveblood " << lcl_savedata(corrosiveblood).buffer() << "\n";
        os << "    totalkillsever " << lcl_savedata(totalkillsever).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("symbol"))
                    lcl_loaddata(_value, symbol);
                if (!_name.strcmp("attr"))
                    lcl_loaddata(_value, attr);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("descr"))
                    lcl_loaddata(_value, descr);
                if (!_name.strcmp("isfriendly"))
                    lcl_loaddata(_value, isfriendly);
                if (!_name.strcmp("melee_attack"))
                    lcl_loaddata(_value, melee_attack);
                if (!_name.strcmp("range_valid"))
                    lcl_loaddata(_value, range_valid);
                if (!_name.strcmp("range_attack"))
                    lcl_loaddata(_value, range_attack);
                if (!_name.strcmp("range_range"))
                    lcl_loaddata(_value, range_range);
                if (!_name.strcmp("range_recharge"))
                    lcl_loaddata(_value, range_recharge);
                if (!_name.strcmp("range_symbol"))
                    lcl_loaddata(_value, range_symbol);
                if (!_name.strcmp("range_attr"))
                    lcl_loaddata(_value, range_attr);
                if (!_name.strcmp("max_hp"))
                    lcl_loaddata(_value, max_hp);
                if (!_name.strcmp("max_mp"))
                    lcl_loaddata(_value, max_mp);
                if (!_name.strcmp("damagereduction"))
                    lcl_loaddata(_value, damagereduction);
                if (!_name.strcmp("dodgebonus"))
                    lcl_loaddata(_value, dodgebonus);
                if (!_name.strcmp("depth"))
                    lcl_loaddata(_value, depth);
                if (!_name.strcmp("rarity"))
                    lcl_loaddata(_value, rarity);
                if (!_name.strcmp("ai"))
                    lcl_loaddata(_value, ai);
                if (!_name.strcmp("corpsechance"))
                    lcl_loaddata(_value, corpsechance);
                if (!_name.strcmp("corpse_effect"))
                    lcl_loaddata(_value, corpse_effect);
                if (!_name.strcmp("loot"))
                    lcl_loaddata(_value, loot);
                if (!_name.strcmp("vulnerability"))
                    lcl_loaddata(_value, vulnerability);
                if (!_name.strcmp("resistance"))
                    lcl_loaddata(_value, resistance);
                if (!_name.strcmp("isslow"))
                    lcl_loaddata(_value, isslow);
                if (!_name.strcmp("isfast"))
                    lcl_loaddata(_value, isfast);
                if (!_name.strcmp("isvampire"))
                    lcl_loaddata(_value, isvampire);
                if (!_name.strcmp("hidefromlos"))
                    lcl_loaddata(_value, hidefromlos);
                if (!_name.strcmp("isregenerate"))
                    lcl_loaddata(_value, isregenerate);
                if (!_name.strcmp("passwall"))
                    lcl_loaddata(_value, passwall);
                if (!_name.strcmp("candig"))
                    lcl_loaddata(_value, candig);
                if (!_name.strcmp("swallows"))
                    lcl_loaddata(_value, swallows);
                if (!_name.strcmp("breeder"))
                    lcl_loaddata(_value, breeder);
                if (!_name.strcmp("isthief"))
                    lcl_loaddata(_value, isthief);
                if (!_name.strcmp("canleap"))
                    lcl_loaddata(_value, canleap);
                if (!_name.strcmp("sightrange"))
                    lcl_loaddata(_value, sightrange);
                if (!_name.strcmp("corrosiveblood"))
                    lcl_loaddata(_value, corrosiveblood);
                if (!_name.strcmp("totalkillsever"))
                    lcl_loaddata(_value, totalkillsever);

            }
            else
                break;
        }
    }


};

extern const MOB_DEF glb_mobdefs[];

struct ARMOURSLOT_DEF
{
    const char * name;
    int coverage;


    void reset()
    {
        name = "body";
        coverage = 50;

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    coverage " << lcl_savedata(coverage).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("coverage"))
                    lcl_loaddata(_value, coverage);

            }
            else
                break;
        }
    }


};

extern const ARMOURSLOT_DEF glb_armourslotdefs[];

struct ITEMCLASS_DEF
{
    const char * name;
    u8 symbol;


    void reset()
    {
        name = "no class";
        symbol = '~';

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    symbol " << lcl_savedata(symbol).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("symbol"))
                    lcl_loaddata(_value, symbol);

            }
            else
                break;
        }
    }


};

extern const ITEMCLASS_DEF glb_itemclassdefs[];

struct ITEM_DEF
{
    const char * name;
    int timer;
    int rarity;
    int depth;
    bool thesaurus;
    bool isflag;
    u8 symbol;
    int attr;
    bool exclusive;
    bool needsmaterial;
    bool gildable;
    u8 mass;
    int itemclass;
    int spell;
    const char * gaintxt;
    const char * losetxt;
    bool needtarget;
    bool unstackable;
    int startstack;
    int melee_attack;
    int damagereduction;
    int armourslot;
    u8 range_range;
    u8 range_power;
    u8 range_consistency;
    u8 range_area;
    const char * range_verb;
    u8 range_symbol;
    int range_attr;
    int ammo;
    bool startsbroken;
    bool discardextra;


    void reset()
    {
        name = "unnamed";
        timer = -1;
        rarity = 100;
        depth = 0;
        thesaurus = false;
        isflag = false;
        symbol = '&';
        attr = ATTR_CYAN;
        exclusive = false;
        needsmaterial = false;
        gildable = false;
        mass = 1;
        itemclass = ITEMCLASS_NONE;
        spell = SPELL_NONE;
        gaintxt = 0;
        losetxt = 0;
        needtarget = false;
        unstackable = false;
        startstack = 1;
        melee_attack = ATTACK_NONE;
        damagereduction = 0;
        armourslot = ARMOURSLOT_NONE;
        range_range = 0;
        range_power = 0;
        range_consistency = 0;
        range_area = 1;
        range_verb = "shoot";
        range_symbol = '*';
        range_attr = ATTR_NORMAL;
        ammo = ITEM_NONE;
        startsbroken = false;
        discardextra = false;

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    timer " << lcl_savedata(timer).buffer() << "\n";
        os << "    rarity " << lcl_savedata(rarity).buffer() << "\n";
        os << "    depth " << lcl_savedata(depth).buffer() << "\n";
        os << "    thesaurus " << lcl_savedata(thesaurus).buffer() << "\n";
        os << "    isflag " << lcl_savedata(isflag).buffer() << "\n";
        os << "    symbol " << lcl_savedata(symbol).buffer() << "\n";
        os << "    attr " << lcl_savedata(attr).buffer() << "\n";
        os << "    exclusive " << lcl_savedata(exclusive).buffer() << "\n";
        os << "    needsmaterial " << lcl_savedata(needsmaterial).buffer() << "\n";
        os << "    gildable " << lcl_savedata(gildable).buffer() << "\n";
        os << "    mass " << lcl_savedata(mass).buffer() << "\n";
        os << "    itemclass " << lcl_savedata(itemclass).buffer() << "\n";
        os << "    spell " << lcl_savedata(spell).buffer() << "\n";
        os << "    gaintxt " << lcl_savedata(gaintxt).buffer() << "\n";
        os << "    losetxt " << lcl_savedata(losetxt).buffer() << "\n";
        os << "    needtarget " << lcl_savedata(needtarget).buffer() << "\n";
        os << "    unstackable " << lcl_savedata(unstackable).buffer() << "\n";
        os << "    startstack " << lcl_savedata(startstack).buffer() << "\n";
        os << "    melee_attack " << lcl_savedata(melee_attack).buffer() << "\n";
        os << "    damagereduction " << lcl_savedata(damagereduction).buffer() << "\n";
        os << "    armourslot " << lcl_savedata(armourslot).buffer() << "\n";
        os << "    range_range " << lcl_savedata(range_range).buffer() << "\n";
        os << "    range_power " << lcl_savedata(range_power).buffer() << "\n";
        os << "    range_consistency " << lcl_savedata(range_consistency).buffer() << "\n";
        os << "    range_area " << lcl_savedata(range_area).buffer() << "\n";
        os << "    range_verb " << lcl_savedata(range_verb).buffer() << "\n";
        os << "    range_symbol " << lcl_savedata(range_symbol).buffer() << "\n";
        os << "    range_attr " << lcl_savedata(range_attr).buffer() << "\n";
        os << "    ammo " << lcl_savedata(ammo).buffer() << "\n";
        os << "    startsbroken " << lcl_savedata(startsbroken).buffer() << "\n";
        os << "    discardextra " << lcl_savedata(discardextra).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("timer"))
                    lcl_loaddata(_value, timer);
                if (!_name.strcmp("rarity"))
                    lcl_loaddata(_value, rarity);
                if (!_name.strcmp("depth"))
                    lcl_loaddata(_value, depth);
                if (!_name.strcmp("thesaurus"))
                    lcl_loaddata(_value, thesaurus);
                if (!_name.strcmp("isflag"))
                    lcl_loaddata(_value, isflag);
                if (!_name.strcmp("symbol"))
                    lcl_loaddata(_value, symbol);
                if (!_name.strcmp("attr"))
                    lcl_loaddata(_value, attr);
                if (!_name.strcmp("exclusive"))
                    lcl_loaddata(_value, exclusive);
                if (!_name.strcmp("needsmaterial"))
                    lcl_loaddata(_value, needsmaterial);
                if (!_name.strcmp("gildable"))
                    lcl_loaddata(_value, gildable);
                if (!_name.strcmp("mass"))
                    lcl_loaddata(_value, mass);
                if (!_name.strcmp("itemclass"))
                    lcl_loaddata(_value, itemclass);
                if (!_name.strcmp("spell"))
                    lcl_loaddata(_value, spell);
                if (!_name.strcmp("gaintxt"))
                    lcl_loaddata(_value, gaintxt);
                if (!_name.strcmp("losetxt"))
                    lcl_loaddata(_value, losetxt);
                if (!_name.strcmp("needtarget"))
                    lcl_loaddata(_value, needtarget);
                if (!_name.strcmp("unstackable"))
                    lcl_loaddata(_value, unstackable);
                if (!_name.strcmp("startstack"))
                    lcl_loaddata(_value, startstack);
                if (!_name.strcmp("melee_attack"))
                    lcl_loaddata(_value, melee_attack);
                if (!_name.strcmp("damagereduction"))
                    lcl_loaddata(_value, damagereduction);
                if (!_name.strcmp("armourslot"))
                    lcl_loaddata(_value, armourslot);
                if (!_name.strcmp("range_range"))
                    lcl_loaddata(_value, range_range);
                if (!_name.strcmp("range_power"))
                    lcl_loaddata(_value, range_power);
                if (!_name.strcmp("range_consistency"))
                    lcl_loaddata(_value, range_consistency);
                if (!_name.strcmp("range_area"))
                    lcl_loaddata(_value, range_area);
                if (!_name.strcmp("range_verb"))
                    lcl_loaddata(_value, range_verb);
                if (!_name.strcmp("range_symbol"))
                    lcl_loaddata(_value, range_symbol);
                if (!_name.strcmp("range_attr"))
                    lcl_loaddata(_value, range_attr);
                if (!_name.strcmp("ammo"))
                    lcl_loaddata(_value, ammo);
                if (!_name.strcmp("startsbroken"))
                    lcl_loaddata(_value, startsbroken);
                if (!_name.strcmp("discardextra"))
                    lcl_loaddata(_value, discardextra);

            }
            else
                break;
        }
    }


};

extern const ITEM_DEF glb_itemdefs[];

struct SPELL_DEF
{
    const char * name;
    const char * verb;
    const char * runes;
    const char * descr;
    u8 symbol;
    int attr;
    int mana;
    bool needsdir;
    bool piercing;
    int radius;
    int range;
    int effect;
    int item;


    void reset()
    {
        name = "unnamed";
        verb = "zap";
        runes = "~~~";
        descr = "Does nothing.";
        symbol = '*';
        attr = ATTR_FIRE;
        mana = 0;
        needsdir = true;
        piercing = false;
        radius = 1;
        range = 10;
        effect = EFFECT_NONE;
        item = ITEM_NONE;

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    verb " << lcl_savedata(verb).buffer() << "\n";
        os << "    runes " << lcl_savedata(runes).buffer() << "\n";
        os << "    descr " << lcl_savedata(descr).buffer() << "\n";
        os << "    symbol " << lcl_savedata(symbol).buffer() << "\n";
        os << "    attr " << lcl_savedata(attr).buffer() << "\n";
        os << "    mana " << lcl_savedata(mana).buffer() << "\n";
        os << "    needsdir " << lcl_savedata(needsdir).buffer() << "\n";
        os << "    piercing " << lcl_savedata(piercing).buffer() << "\n";
        os << "    radius " << lcl_savedata(radius).buffer() << "\n";
        os << "    range " << lcl_savedata(range).buffer() << "\n";
        os << "    effect " << lcl_savedata(effect).buffer() << "\n";
        os << "    item " << lcl_savedata(item).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("verb"))
                    lcl_loaddata(_value, verb);
                if (!_name.strcmp("runes"))
                    lcl_loaddata(_value, runes);
                if (!_name.strcmp("descr"))
                    lcl_loaddata(_value, descr);
                if (!_name.strcmp("symbol"))
                    lcl_loaddata(_value, symbol);
                if (!_name.strcmp("attr"))
                    lcl_loaddata(_value, attr);
                if (!_name.strcmp("mana"))
                    lcl_loaddata(_value, mana);
                if (!_name.strcmp("needsdir"))
                    lcl_loaddata(_value, needsdir);
                if (!_name.strcmp("piercing"))
                    lcl_loaddata(_value, piercing);
                if (!_name.strcmp("radius"))
                    lcl_loaddata(_value, radius);
                if (!_name.strcmp("range"))
                    lcl_loaddata(_value, range);
                if (!_name.strcmp("effect"))
                    lcl_loaddata(_value, effect);
                if (!_name.strcmp("item"))
                    lcl_loaddata(_value, item);

            }
            else
                break;
        }
    }


};

extern const SPELL_DEF glb_spelldefs[];

struct RING_DEF
{
    const char * name;
    int resist;
    int resist_amt;
    int deflect;


    void reset()
    {
        name = "none";
        resist = ELEMENT_NONE;
        resist_amt = 0;
        deflect = 0;

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    resist " << lcl_savedata(resist).buffer() << "\n";
        os << "    resist_amt " << lcl_savedata(resist_amt).buffer() << "\n";
        os << "    deflect " << lcl_savedata(deflect).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("resist"))
                    lcl_loaddata(_value, resist);
                if (!_name.strcmp("resist_amt"))
                    lcl_loaddata(_value, resist_amt);
                if (!_name.strcmp("deflect"))
                    lcl_loaddata(_value, deflect);

            }
            else
                break;
        }
    }


};

extern const RING_DEF glb_ringdefs[];

struct POTION_DEF
{
    const char * name;
    int effect;


    void reset()
    {
        name = "none";
        effect = EFFECT_NONE;

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    effect " << lcl_savedata(effect).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("effect"))
                    lcl_loaddata(_value, effect);

            }
            else
                break;
        }
    }


};

extern const POTION_DEF glb_potiondefs[];

struct MATERIAL_DEF
{
    const char * name;
    const char * adjname;
    bool gildable;
    u8 depth;
    int attr;
    bool burnable;
    bool corrodable;


    void reset()
    {
        name = "ether";
        adjname = "ether";
        gildable = false;
        depth = 0;
        attr = ATTR_WHITE;
        burnable = false;
        corrodable = false;

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    adjname " << lcl_savedata(adjname).buffer() << "\n";
        os << "    gildable " << lcl_savedata(gildable).buffer() << "\n";
        os << "    depth " << lcl_savedata(depth).buffer() << "\n";
        os << "    attr " << lcl_savedata(attr).buffer() << "\n";
        os << "    burnable " << lcl_savedata(burnable).buffer() << "\n";
        os << "    corrodable " << lcl_savedata(corrodable).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("adjname"))
                    lcl_loaddata(_value, adjname);
                if (!_name.strcmp("gildable"))
                    lcl_loaddata(_value, gildable);
                if (!_name.strcmp("depth"))
                    lcl_loaddata(_value, depth);
                if (!_name.strcmp("attr"))
                    lcl_loaddata(_value, attr);
                if (!_name.strcmp("burnable"))
                    lcl_loaddata(_value, burnable);
                if (!_name.strcmp("corrodable"))
                    lcl_loaddata(_value, corrodable);

            }
            else
                break;
        }
    }


};

extern const MATERIAL_DEF glb_materialdefs[];

struct KEY_DEF
{
    u8 val;


    void reset()
    {
        val = ' ';

    }

    void saveData(ostream &os) const
    {
        os << "    val " << lcl_savedata(val).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("val"))
                    lcl_loaddata(_value, val);

            }
            else
                break;
        }
    }


};

extern const KEY_DEF glb_keydefs[];


#endif
