/*
 * Licensed under BSD license.  See LICENCE.TXT  
 *
 * Produced by:	Jeff Lait
 *
 *      	7DRL Development
 *
 * NAME:        speed.cpp ( Live Once Library, C++ )
 *
 * COMMENTS:
 */

#include "glbdef.h"
#include "speed.h"

PHASE_NAMES	glbCurPhase;

int		glbGameMoves = 0;

#define PHASE_LEN	5

// These are very precisely defined!
const PHASE_NAMES glbPhaseOrder[PHASE_LEN] =
{
    PHASE_FAST,
    PHASE_NORMAL,
    PHASE_SLOW,
    PHASE_QUICK,
    PHASE_NORMAL
};


SPEED::SPEED()
{
    myTime = 0;
    incTime();
}

void
SPEED::incTime()
{
    myTime++;
    myPhase = glbPhaseOrder[myTime % PHASE_LEN];
}

void
SPEED::setTime(int time)
{
    myTime = time;
    myPhase = glbPhaseOrder[myTime % PHASE_LEN];
}
