/*
 * Licensed under BSD license.  See LICENCE.TXT  
 *
 * Produced by:	Jeff Lait
 *
 *      	Jacob's Matrix Development
 *
 * NAME:        config.h ( Jacob's Matrix, C++ )
 *
 * COMMENTS:
 */

#ifndef __config__
#define __config__

class CONFIG
{
public:
    void	load(const char *fname);
    void	save(const char *fname);

    bool	musicEnable() const { return myMusicEnable; }
    const char *musicFile() const { return myMusicFile; }
    int		musicVolume() const { return myMusicVolume; }

    bool	screenFull() const { return myFullScreen; }

    // Like why the heck do we want accessors on this flat file?
public:
    bool	myDebug = false;
    bool	myColorBlind = false;
    bool	myEasyMode = false;
    bool	myWallSlide = true;
    bool	myDisplayMap = true;
    bool	myVerbose = false;
    bool	myUseMenus = false;

    int 	myMusicVolume = 5;
    bool	myMusicEnable = true;
    const char *myMusicFile = nullptr;

    int		myMaxMapsPerPos = 64;
    int		myMinBranchFactor = 16;

    bool	myTTSConnect = false;
    bool	myTTSEnable = false;
    int		myTTSSpeed = 10;
    int		myTTSPhraseDelay = 10;
    int		myTTSSentenceDelay = 15;
    int		myTTSParagraphDelay = 20;

    bool	myConsoleConnect = false;

    bool	myFullScreen = false;
};

extern CONFIG *glbConfig;


#endif
