/*
 * Licensed under BSD license.  See LICENCE.TXT  
 *
 * Produced by:	Jeff Lait
 *
 *      	7DRL Development
 *
 * NAME:        speed.cpp ( Live Once Library, C++ )
 *
 * COMMENTS:
 */

#include "glbdef.h"
#include "speed.h"

PHASE_NAMES	glbCurPhase;

int		glbGameMoves = 0;

#define PHASE_LEN	5

// These are very precisely defined!
const PHASE_NAMES glbPhaseOrder[PHASE_LEN] =
{
    PHASE_FAST,
    PHASE_NORMAL,
    PHASE_SLOW,
    PHASE_QUICK,
    PHASE_NORMAL
};


SPEED::SPEED()
{
    myTime = 0;
    incTime();
}

int
SPEED::daylight() const
{
    const int	twilight = 100;
    const int	day = 1000;
    const int	night = 500;

    const int	period = twilight *2 + day + night;
    int phase = myTime % period;

    if (phase < day) return 100;
    phase -= day;
    if (phase < twilight) return 100 - (phase*100 / twilight);
    phase -= twilight;
    if (phase < night) return 0;
    phase -= night;
    return phase * 100 / twilight;
}

void
SPEED::incTime()
{
    myTime++;
    myPhase = glbPhaseOrder[myTime % PHASE_LEN];
}

void
SPEED::setTime(int time)
{
    myTime = time;
    myPhase = glbPhaseOrder[myTime % PHASE_LEN];
}
