/*
 * Licensed under 7DRL license.  See LICENCE.TXT  
 *
 * Produced by:	Jeff Lait
 *
 *      	7DRL Development
 *
 * NAME:        threadpool.cpp ( Pointless, C++ )
 *
 * COMMENTS:
 *	Attempt at a threading pool.
 */

#include "threadpool.h"

class THREADPOOL_OWNER
{
public:
    THREADPOOL_OWNER()
    {
	myPool = new THREADPOOL();
    }
    ~THREADPOOL_OWNER()
    {
	// Intentionaly leak!
    }
    THREADPOOL *pool() const { return myPool; }

protected:
    THREADPOOL *myPool;
};

static void *
threadpool_threadstarter(void *vdata)
{
    THREADPOOL_LIST	*tasklist = (THREADPOOL_LIST *) vdata;

    tasklist->threadLoop();

    return 0;
}

THREADPOOL::THREADPOOL()
{
    int		poolsize = THREAD::numProcessors();

    for (int i = 0; i < poolsize; i++)
    {
	THREAD	*thread = THREAD::alloc();
	thread->start(threadpool_threadstarter, &myTaskList);
    }
}

THREADPOOL *
THREADPOOL::getPool()
{
    static THREADPOOL_OWNER owner;
    return owner.pool();
}

