/*
 * Licensed under BSD license.  See LICENCE.TXT  
 *
 * Produced by:	Jeff Lait
 *
 *      	Jacob's Matrix Development
 *
 * NAME:        config.cpp ( Jacob's Matrix, C++ )
 *
 * COMMENTS:
 */

#include <libtcod.hpp>
#undef CLAMP

#include "config.h"
#include "buf.h"

#include <fstream>
using namespace std;

CONFIG *glbConfig = 0;

void
CONFIG::load(const char *fname)
{
    TCODParser		parser;

    {
	TCODParserStruct	*folder;
	folder =  parser.newStructure("game");
	folder->addProperty("easymode", TCOD_TYPE_BOOL, true);
	folder->addProperty("debug", TCOD_TYPE_BOOL, true);
	folder->addProperty("colorblind", TCOD_TYPE_BOOL, true);
	folder->addProperty("wallslide", TCOD_TYPE_BOOL, true);
	folder->addProperty("usemenus", TCOD_TYPE_BOOL, false);
    }

    {
	TCODParserStruct	*folder;
	folder = parser.newStructure("music");
	folder->addProperty("enable", TCOD_TYPE_BOOL, true);
	folder->addProperty("file", TCOD_TYPE_STRING, true);
	folder->addProperty("volume", TCOD_TYPE_INT, true);
    }

    {
	TCODParserStruct	*folder;
	folder = parser.newStructure("screen");
	folder->addProperty("full", TCOD_TYPE_BOOL, true);
    }

    {
	TCODParserStruct	*folder;
	folder = parser.newStructure("map");
	folder->addProperty("display", TCOD_TYPE_BOOL, true);
	folder->addProperty("verbose", TCOD_TYPE_BOOL, false);
    }

    {
	TCODParserStruct	*folder;
	folder = parser.newStructure("console");
	folder->addProperty("connect", TCOD_TYPE_BOOL, true);
    }

    {
	TCODParserStruct	*folder;
	folder = parser.newStructure("tts");
	folder->addProperty("connect", TCOD_TYPE_BOOL, true);
	folder->addProperty("enable", TCOD_TYPE_BOOL, true);
	folder->addProperty("speed", TCOD_TYPE_INT, true);
	folder->addProperty("phrasedelay", TCOD_TYPE_INT, true);
	folder->addProperty("sentencedelay", TCOD_TYPE_INT, true);
	folder->addProperty("paragraphdelay", TCOD_TYPE_INT, true);
    }

    parser.run(fname, 0);

    myEasyMode = parser.getBoolProperty("game.easymode");
    myDebug = parser.getBoolProperty("game.debug");
    myColorBlind = parser.getBoolProperty("game.colorblind");
    myWallSlide = parser.getBoolProperty("game.wallslide");
    myUseMenus = parser.getBoolProperty("game.usemenus");
    myDisplayMap = parser.getBoolProperty("map.display");
    myVerbose = parser.getBoolProperty("map.verbose");

    myMusicEnable = parser.getBoolProperty("music.enable");
    myMusicFile = parser.getStringProperty("music.file");
    myMusicVolume = parser.getIntProperty("music.volume");

    myFullScreen = parser.getBoolProperty("screen.full");

    myConsoleConnect = parser.getBoolProperty("console.connect");

    myTTSConnect = parser.getBoolProperty("tts.connect");
    myTTSEnable = parser.getBoolProperty("tts.enable");
    myTTSSpeed = parser.getIntProperty("tts.speed");
    myTTSPhraseDelay = parser.getIntProperty("tts.phrasedelay");
    myTTSSentenceDelay = parser.getIntProperty("tts.sentencedelay");
    myTTSParagraphDelay = parser.getIntProperty("tts.paragraphdelay");
}

void
CONFIG::save(const char *fname)
{
    // So TCOD has a parser that does thet hard part,
    // of trying to read in a file.

    // But it has no way to write out a changed version?

    // Argh!
    ofstream		os(fname);

    os << "game" << endl;
    os << "{" << endl;
    os << "    easymode = " << (myEasyMode ? "true" : "false") << endl;
    os << "    debug = " << (myDebug ? "true" : "false") << endl;
    os << "    colorblind = " << (myColorBlind ? "true" : "false") << endl;
    os << "    wallslide = " << (myWallSlide ? "true" : "false") << endl;
    os << "    usemenus = " << (myUseMenus ? "true" : "false") << endl;
    os << "}" << endl;
    os << endl;

    os << "music" << endl;
    os << "{" << endl;
    os << "    enable = " << (myMusicEnable ? "true" : "false") << endl;
    // Heaven help you if you have " in your file as we don't escape here.
    os << "    file = \"" << myMusicFile << "\"" << endl;
    os << "    volume = " << myMusicVolume << endl;
    os << "}" << endl;
    os << endl;

    os << "map" << endl;
    os << "{" << endl;
    os << "    display = " << (myDisplayMap ? "true" : "false") << endl;
    os << "    verbose = " << (myVerbose ? "true" : "false") << endl;
    os << "}" << endl;
    os << endl;

    os << "console" << endl;
    os << "{" << endl;
    os << "    connect = " << (myConsoleConnect ? "true" : "false") << endl;
    os << "}" << endl;
    os << endl;

    os << "tts" << endl;
    os << "{" << endl;
    os << "    connect = " << (myTTSConnect ? "true" : "false") << endl;
    os << "    enable = " << (myTTSEnable ? "true" : "false") << endl;
    os << "    speed = " << myTTSSpeed << endl;
    os << "    phrasedelay = " << myTTSPhraseDelay << endl;
    os << "    sentencedelay = " << myTTSSentenceDelay << endl;
    os << "    paragraphdelay = " << myTTSParagraphDelay << endl;
    os << "}" << endl;
    os << endl;

    os << "screen" << endl;
    os << "{" << endl;
    os << "    full = " << (myFullScreen ? "true" : "false") << endl;
    os << "}" << endl;
    os << endl;
}
