// Automatically generated by enummaker.py.
//DO NOT EDIT THIS FILE (Yes, I mean you!)
#ifndef __glbdef_h__
#define __glbdef_h__

#include "mygba.h"
#include "rand.h"
#include "buf.h"

inline BUF lcl_savedata(int data)
{
    BUF buf;
    buf.sprintf("%d", data);
    return buf;
}

inline BUF lcl_savedata(u8 data)
{
    BUF buf;
    buf.sprintf("%d", data);
    return buf;
}

inline BUF lcl_savedata(bool data)
{
    BUF buf;
    buf.sprintf("%s", data ? "true" : "false");
    return buf;
}

inline BUF lcl_savedata(const char *data)
{
    BUF buf;
    buf.reference(data);
    buf = buf.protectWithQuotes();
    return buf;
}

inline BUF lcl_savedata(const DICE &dice)
{
    BUF buf;
    buf.sprintf("%dd%d%+d", dice.myNumDie, dice.mySides, dice.myBonus);
    return buf;
}

inline void lcl_loaddata(BUF buf, int &data)
{
    data = atoi(buf.buffer());
}

inline void lcl_loaddata(BUF buf, u8 &data)
{
    if (buf.startsWith("'"))
    {
        data = buf.buffer()[1];
    }
    else
        data = atoi(buf.buffer());
}

inline void lcl_loaddata(BUF buf, bool &data)
{
    if (!buf.strcasecmp("true"))
        data = true;
    else if (!buf.strcasecmp("false"))
        data = false;
    else data = atoi(buf.buffer()) != 0;
}

inline void lcl_loaddata(BUF buf, DICE &data)
{
    data.scanf(buf);
}

inline void lcl_loaddata(BUF buf, const char *&data)
{
    // Leak!  Joyous Leaks!
    data = buf.strdup();
}

enum WORLD_NAMES
{
    WORLD_WIZARD,
    WORLD_THIEF,
    WORLD_FIGHTER,

    NUM_WORLDS
};

#define FOREACH_WORLD(x) \
    for ((x) = (WORLD_NAMES) 0; \
         (x) < NUM_WORLDS; \
         (x) = (WORLD_NAMES) ((int)(x)+1))
enum WORLDLIST_NAMES
{
    WORLDLIST_NONE,
    WORLDLIST_THIEF,
    WORLDLIST_WIZARD,
    WORLDLIST_FIGHTER,
    WORLDLIST_ADHOC1,
    WORLDLIST_ADHOC2,
    WORLDLIST_ALL,
    WORLDLIST_ADHOC3,
    WORLDLIST_WF,
    WORLDLIST_ADHOC4,
    WORLDLIST_WT,
    WORLDLIST_ADHOC5,
    WORLDLIST_TF,

    NUM_WORLDLISTS
};

#define FOREACH_WORLDLIST(x) \
    for ((x) = (WORLDLIST_NAMES) 0; \
         (x) < NUM_WORLDLISTS; \
         (x) = (WORLDLIST_NAMES) ((int)(x)+1))
enum ROLE_NAMES
{
    ROLE_NONE,
    ROLE_THIEF,
    ROLE_WIZARD,
    ROLE_FIGHTER,

    NUM_ROLES
};

#define FOREACH_ROLE(x) \
    for ((x) = (ROLE_NAMES) 0; \
         (x) < NUM_ROLES; \
         (x) = (ROLE_NAMES) ((int)(x)+1))
enum ROLELIST_NAMES
{
    ROLELIST_NONE,
    ROLELIST_W,
    ROLELIST_T,
    ROLELIST_F,
    ROLELIST_WT,
    ROLELIST_WF,
    ROLELIST_TF,
    ROLELIST_ALL,

    NUM_ROLELISTS
};

#define FOREACH_ROLELIST(x) \
    for ((x) = (ROLELIST_NAMES) 0; \
         (x) < NUM_ROLELISTS; \
         (x) = (ROLELIST_NAMES) ((int)(x)+1))
enum STRATEGY_NAMES
{
    STRATEGY_NONE,
    STRATEGY_CHARGE,
    STRATEGY_PINCER,
    STRATEGY_LINE,
    STRATEGY_HOLDCENTER,
    STRATEGY_RESERVE,
    STRATEGY_PAIR,
    STRATEGY_FLANK,

    NUM_STRATEGYS
};

#define FOREACH_STRATEGY(x) \
    for ((x) = (STRATEGY_NAMES) 0; \
         (x) < NUM_STRATEGYS; \
         (x) = (STRATEGY_NAMES) ((int)(x)+1))
enum HEALTHLEVEL_NAMES
{
    HEALTHLEVEL_DEAD,
    HEALTHLEVEL_DEATHSGATE,
    HEALTHLEVEL_CRITICALLYINJURED,
    HEALTHLEVEL_SEVERELYINJURED,
    HEALTHLEVEL_INJURED,
    HEALTHLEVEL_BLOODIED,
    HEALTHLEVEL_BRUISED,
    HEALTHLEVEL_SCRATCHED,
    HEALTHLEVEL_FULL,

    NUM_HEALTHLEVELS
};

#define FOREACH_HEALTHLEVEL(x) \
    for ((x) = (HEALTHLEVEL_NAMES) 0; \
         (x) < NUM_HEALTHLEVELS; \
         (x) = (HEALTHLEVEL_NAMES) ((int)(x)+1))
enum FOODLEVEL_NAMES
{
    FOODLEVEL_STARVING,
    FOODLEVEL_HUNGRY,
    FOODLEVEL_FULL,
    FOODLEVEL_SATIATED,

    NUM_FOODLEVELS
};

#define FOREACH_FOODLEVEL(x) \
    for ((x) = (FOODLEVEL_NAMES) 0; \
         (x) < NUM_FOODLEVELS; \
         (x) = (FOODLEVEL_NAMES) ((int)(x)+1))
enum SOLDIER_NAMES
{
    SOLDIER_WAIT,
    SOLDIER_MARCH,
    SOLDIER_FIRE,
    SOLDIER_SENDMESSAGE,
    SOLDIER_RETURN,

    NUM_SOLDIERS
};

#define FOREACH_SOLDIER(x) \
    for ((x) = (SOLDIER_NAMES) 0; \
         (x) < NUM_SOLDIERS; \
         (x) = (SOLDIER_NAMES) ((int)(x)+1))
enum PHASE_NAMES
{
    PHASE_NORMAL,
    PHASE_FAST,
    PHASE_SLOW,
    PHASE_QUICK,

    NUM_PHASES
};

#define FOREACH_PHASE(x) \
    for ((x) = (PHASE_NAMES) 0; \
         (x) < NUM_PHASES; \
         (x) = (PHASE_NAMES) ((int)(x)+1))
enum SIZE_NAMES
{
    SIZE_NONE,
    SIZE_TINY,
    SIZE_SMALL,
    SIZE_MEDIUM,
    SIZE_LARGE,
    SIZE_GIANT,

    NUM_SIZES
};

#define FOREACH_SIZE(x) \
    for ((x) = (SIZE_NAMES) 0; \
         (x) < NUM_SIZES; \
         (x) = (SIZE_NAMES) ((int)(x)+1))
enum EFFECTCLASS_NAMES
{
    EFFECTCLASS_NONE,
    EFFECTCLASS_HEAL,
    EFFECTCLASS_GAINMANA,
    EFFECTCLASS_LOSEMANA,
    EFFECTCLASS_GAINFOOD,
    EFFECTCLASS_LOSEFOOD,
    EFFECTCLASS_POISON,
    EFFECTCLASS_CURE,
    EFFECTCLASS_DAMAGE,
    EFFECTCLASS_SCALED_DAMAGE,
    EFFECTCLASS_RESIST,
    EFFECTCLASS_VULNERABLE,
    EFFECTCLASS_GAINITEM,

    NUM_EFFECTCLASSS
};

#define FOREACH_EFFECTCLASS(x) \
    for ((x) = (EFFECTCLASS_NAMES) 0; \
         (x) < NUM_EFFECTCLASSS; \
         (x) = (EFFECTCLASS_NAMES) ((int)(x)+1))
enum EFFECT_NAMES
{
    EFFECT_NONE,
    EFFECT_VULN_FIRE,
    EFFECT_VULN_ICE,
    EFFECT_VULN_POISON,
    EFFECT_VULN_ACID,
    EFFECT_VULN_ELECTRICITY,
    EFFECT_CORPSE_APPLYPOISON,
    EFFECT_CORPSE_RESIST_FIRE,
    EFFECT_CORPSE_RESIST_ICE,
    EFFECT_CORPSE_RESIST_POISON,
    EFFECT_CORPSE_RESIST_ELECTRICITY,
    EFFECT_CORPSE_RESIST_ACID,
    EFFECT_POISONCORPSE,
    EFFECT_HASTECORPSE,
    EFFECT_PLAGUECORPSE,
    EFFECT_ACIDCORPSE,
    EFFECT_ADHOC45,
    EFFECT_ADHOC155,
    EFFECT_ADHOC170,
    EFFECT_ADHOC171,
    EFFECT_ADHOC174,
    EFFECT_ADHOC177,
    EFFECT_SCROLL_FIRE,
    EFFECT_ADHOC194,
    EFFECT_ADHOC195,
    EFFECT_ADHOC196,
    EFFECT_ADHOC197,
    EFFECT_ADHOC198,
    EFFECT_ADHOC199,
    EFFECT_ADHOC200,
    EFFECT_COLOURSPRAY_RED,
    EFFECT_ADHOC201,
    EFFECT_COLOURSPRAY_ORANGE,
    EFFECT_ADHOC202,
    EFFECT_COLOURSPRAY_YELLOW,
    EFFECT_ADHOC203,
    EFFECT_COLOURSPRAY_GREEN,
    EFFECT_ADHOC204,
    EFFECT_COLOURSPRAY_BLUE,
    EFFECT_ADHOC205,
    EFFECT_COLOURSPRAY_VIOLET,
    EFFECT_ADHOC206,
    EFFECT_ADHOC207,
    EFFECT_SPELL_LIGHTNINGBOLT,
    EFFECT_ADHOC208,
    EFFECT_SPELL_SHOCK,
    EFFECT_ADHOC209,
    EFFECT_ADHOC210,
    EFFECT_SPELL_FIREBALL,
    EFFECT_ADHOC211,
    EFFECT_ADHOC212,
    EFFECT_ADHOC213,
    EFFECT_ADHOC214,
    EFFECT_ADHOC215,
    EFFECT_ADHOC216,
    EFFECT_ADHOC217,
    EFFECT_ADHOC218,
    EFFECT_ADHOC219,
    EFFECT_ADHOC221,
    EFFECT_ADHOC223,
    EFFECT_ADHOC225,
    EFFECT_ADHOC227,

    NUM_EFFECTS
};

#define FOREACH_EFFECT(x) \
    for ((x) = (EFFECT_NAMES) 0; \
         (x) < NUM_EFFECTS; \
         (x) = (EFFECT_NAMES) ((int)(x)+1))
enum ELEMENT_NAMES
{
    ELEMENT_NONE,
    ELEMENT_PHYSICAL,
    ELEMENT_POISON,
    ELEMENT_ACID,
    ELEMENT_LIGHT,
    ELEMENT_ELECTRICITY,
    ELEMENT_FIRE,
    ELEMENT_ICE,

    NUM_ELEMENTS
};

#define FOREACH_ELEMENT(x) \
    for ((x) = (ELEMENT_NAMES) 0; \
         (x) < NUM_ELEMENTS; \
         (x) = (ELEMENT_NAMES) ((int)(x)+1))
enum DAMAGECLASS_NAMES
{
    DAMAGECLASS_NONE,
    DAMAGECLASS_PIERCE,
    DAMAGECLASS_BLUNT,
    DAMAGECLASS_SLASH,
    DAMAGECLASS_BYPASS,
    DAMAGECLASS_SPLASH,
    DAMAGECLASS_DODGE,

    NUM_DAMAGECLASSS
};

#define FOREACH_DAMAGECLASS(x) \
    for ((x) = (DAMAGECLASS_NAMES) 0; \
         (x) < NUM_DAMAGECLASSS; \
         (x) = (DAMAGECLASS_NAMES) ((int)(x)+1))
enum ATTACKSTYLE_NAMES
{
    ATTACKSTYLE_MELEE,
    ATTACKSTYLE_RANGE,
    ATTACKSTYLE_INTERNAL,

    NUM_ATTACKSTYLES
};

#define FOREACH_ATTACKSTYLE(x) \
    for ((x) = (ATTACKSTYLE_NAMES) 0; \
         (x) < NUM_ATTACKSTYLES; \
         (x) = (ATTACKSTYLE_NAMES) ((int)(x)+1))
enum CHAMBER_NAMES
{
    CHAMBER_NONE,
    CHAMBER_LARGEROOM,
    CHAMBER_LONGHALLWAY_NS,
    CHAMBER_LONGHALLWAY_WE,
    CHAMBER_SHORTHALLWAY_NS,
    CHAMBER_SHORTHALLWAY_WE,
    CHAMBER_ELBOW_NE,
    CHAMBER_ELBOW_SE,
    CHAMBER_ELBOW_NW,
    CHAMBER_ELBOW_SW,
    CHAMBER_SMALLROOM,

    NUM_CHAMBERS
};

#define FOREACH_CHAMBER(x) \
    for ((x) = (CHAMBER_NAMES) 0; \
         (x) < NUM_CHAMBERS; \
         (x) = (CHAMBER_NAMES) ((int)(x)+1))
enum ROOMTYPE_NAMES
{
    ROOMTYPE_NONE,
    ROOMTYPE_THIEF_FINAL,
    ROOMTYPE_FIGHTER_FINAL,
    ROOMTYPE_WIZARD_FINAL,
    ROOMTYPE_VILLAGE,
    ROOMTYPE_FACE,
    ROOMTYPE_ATRIUM,
    ROOMTYPE_CORRIDOR,
    ROOMTYPE_BARRACKS,
    ROOMTYPE_GUARDHOUSE,
    ROOMTYPE_THRONEROOM,
    ROOMTYPE_VAULT,
    ROOMTYPE_LIBRARY,
    ROOMTYPE_KITCHEN,
    ROOMTYPE_DININGROOM,
    ROOMTYPE_PANTRY,
    ROOMTYPE_ROGUE,
    ROOMTYPE_CAVE,
    ROOMTYPE_DARKCAVE,
    ROOMTYPE_MAZE,
    ROOMTYPE_MAGE,
    ROOMTYPE_PALACE,
    ROOMTYPE_CAVEROOMS,
    ROOMTYPE_BIGROOM,
    ROOMTYPE_WILDERNESS,

    NUM_ROOMTYPES
};

#define FOREACH_ROOMTYPE(x) \
    for ((x) = (ROOMTYPE_NAMES) 0; \
         (x) < NUM_ROOMTYPES; \
         (x) = (ROOMTYPE_NAMES) ((int)(x)+1))
enum LEVEL_NAMES
{
    LEVEL_NONE,
    LEVEL_ONE,

    NUM_LEVELS
};

#define FOREACH_LEVEL(x) \
    for ((x) = (LEVEL_NAMES) 0; \
         (x) < NUM_LEVELS; \
         (x) = (LEVEL_NAMES) ((int)(x)+1))
enum GAMERULES_NAMES
{
    GAMERULES_OFFICIAL,

    NUM_GAMERULESS
};

#define FOREACH_GAMERULES(x) \
    for ((x) = (GAMERULES_NAMES) 0; \
         (x) < NUM_GAMERULESS; \
         (x) = (GAMERULES_NAMES) ((int)(x)+1))
enum YELL_NAMES
{
    YELL_KEEPOUT,
    YELL_MURDERER,
    YELL_INVADER,
    YELL_KILL,
    YELL_KILLCHASE,
    YELL_LOCATION,
    YELL_HEARDLOCATION,
    YELL_TAUNT,
    YELL_VICTORY,
    YELL_RANGED,

    NUM_YELLS
};

#define FOREACH_YELL(x) \
    for ((x) = (YELL_NAMES) 0; \
         (x) < NUM_YELLS; \
         (x) = (YELL_NAMES) ((int)(x)+1))
enum HELP_NAMES
{
    HELP_WTF,
    HELP_ROGUELIKES,
    HELP_MOVEMENT,
    HELP_INVENTORY,
    HELP_KEYBOARD,
    HELP_WELCOME,
    HELP_ABOUT,

    NUM_HELPS
};

#define FOREACH_HELP(x) \
    for ((x) = (HELP_NAMES) 0; \
         (x) < NUM_HELPS; \
         (x) = (HELP_NAMES) ((int)(x)+1))
enum OPTION_NAMES
{
    OPTION_HELP,
    OPTION_FULLSCREEN,
    OPTION_USEMENUS,
    OPTION_VERBOSITY,
    OPTION_WALLSLIDE,
    OPTION_PLAY,
    OPTION_QUIT,

    NUM_OPTIONS
};

#define FOREACH_OPTION(x) \
    for ((x) = (OPTION_NAMES) 0; \
         (x) < NUM_OPTIONS; \
         (x) = (OPTION_NAMES) ((int)(x)+1))
enum ACTION_NAMES
{
    ACTION_NONE,
    ACTION_RESTART,
    ACTION_BUMP,
    ACTION_FIRE,
    ACTION_READYRANGED,
    ACTION_ROTATE,
    ACTION_REBOOTAVATAR,
    ACTION_DROP,
    ACTION_DROPALL,
    ACTION_DROPTOP,
    ACTION_BAGSHAKE,
    ACTION_BAGSWAPTOP,
    ACTION_BREAK,
    ACTION_BREAKTOP,
    ACTION_INSPECT,
    ACTION_QUAFF,
    ACTION_QUAFFTOP,
    ACTION_FORGET,
    ACTION_EAT,
    ACTION_EATGROUND,
    ACTION_READ,
    ACTION_EATTOP,
    ACTION_SUICIDE,
    ACTION_MEDITATE,
    ACTION_SEARCH,
    ACTION_WAIT,
    ACTION_WAITUNTIL,
    ACTION_STOPWAITING,
    ACTION_EXAMINE,
    ACTION_SAVE,
    ACTION_SHUTDOWN,
    ACTION_CREATEITEM,
    ACTION_CAST,
    ACTION_THROW,
    ACTION_THROWTOP,
    ACTION_WEAR,
    ACTION_WIELD,
    ACTION_WEARTOP,
    ACTION_CLIMB,
    ACTION_PICKUP,
    ACTION_PICKUPSPECIFIC,
    ACTION_TRANSMUTE,
    ACTION_MARK_QUEUE_EMPTY,
    ACTION_GHOSTMOVE,
    ACTION_GHOSTMOVEABS,
    ACTION_GHOSTRECENTER,
    ACTION_PORTAL,
    ACTION_OPEN,
    ACTION_CLOSE,
    ACTION_KICK,
    ACTION_APPLY,
    ACTION_WORLDSHIFT,

    NUM_ACTIONS
};

#define FOREACH_ACTION(x) \
    for ((x) = (ACTION_NAMES) 0; \
         (x) < NUM_ACTIONS; \
         (x) = (ACTION_NAMES) ((int)(x)+1))
enum GOSSIP_NAMES
{
    GOSSIP_INTRO,
    GOSSIP_MEDITATE,
    GOSSIP_EQUIP,

    NUM_GOSSIPS
};

#define FOREACH_GOSSIP(x) \
    for ((x) = (GOSSIP_NAMES) 0; \
         (x) < NUM_GOSSIPS; \
         (x) = (GOSSIP_NAMES) ((int)(x)+1))
enum ATTR_NAMES
{
    ATTR_NONE,
    ATTR_TERMINAL,
    ATTR_HEALTH,
    ATTR_MANA,
    ATTR_FOOD,
    ATTR_POWERBAR,
    ATTR_BORDER,
    ATTR_VICTORYBORDER,
    ATTR_DEATHBORDER,
    ATTR_DEATHBAR,
    ATTR_WAITBAR,
    ATTR_INVULNERABLE,
    ATTR_HILITE,
    ATTR_DKHILITE,
    ATTR_AVATARMEDITATE,
    ATTR_WAYPOINT,
    ATTR_LTWAYPOINT,
    ATTR_ELECTRICBLUE,
    ATTR_METAL,
    ATTR_BLUEPORTAL,
    ATTR_ORANGEPORTAL,
    ATTR_WISH,
    ATTR_FIRE,
    ATTR_ICE,
    ATTR_SEARCH,
    ATTR_GOLD,
    ATTR_YELLOW,
    ATTR_LTYELLOW,
    ATTR_INV_YELLOW,
    ATTR_SHOUT,
    ATTR_EMOTE,
    ATTR_PINK,
    ATTR_PURPLE,
    ATTR_NORMAL,
    ATTR_LIGHTBLACK,
    ATTR_OUTOFFOV,
    ATTR_WHITE,
    ATTR_INV_WHITE,
    ATTR_ORANGE,
    ATTR_DKORANGE,
    ATTR_INV_ORANGE,
    ATTR_LIGHTBROWN,
    ATTR_BROWN,
    ATTR_LTRED,
    ATTR_RED,
    ATTR_INV_RED,
    ATTR_DKRED,
    ATTR_GREEN,
    ATTR_LTGREEN,
    ATTR_INV_GREEN,
    ATTR_GREEN_ISLE,
    ATTR_DKGREEN,
    ATTR_DKRGREEN,
    ATTR_BLUE,
    ATTR_LTBLUE,
    ATTR_INV_BLUE,
    ATTR_LIGHTBLUE,
    ATTR_TEAL,
    ATTR_CYAN,
    ATTR_DKCYAN,
    ATTR_DKGREY,
    ATTR_GREY,
    ATTR_LTGREY,
    ATTR_PERCENT_SELECT,
    ATTR_PERCENT_HILIGHT,
    ATTR_PERCENT_SELECTHILIGHT,

    NUM_ATTRS
};

#define FOREACH_ATTR(x) \
    for ((x) = (ATTR_NAMES) 0; \
         (x) < NUM_ATTRS; \
         (x) = (ATTR_NAMES) ((int)(x)+1))
enum MAPFLAG_NAMES
{
    MAPFLAG_NONE = 0,
    MAPFLAG_FOV = 1,
    MAPFLAG_FOVCACHE = 2,
    MAPFLAG_PORTAL = 4,
    MAPFLAG_TRAP = 8,
    MAPFLAG_SEEN_PUSHER = 16,
    MAPFLAG_MOB = 32,
    MAPFLAG_ITEM = 64,
    MAPFLAG_MAPPED = 128,

    NUM_MAPFLAGS
};

#define FOREACH_MAPFLAG(x) \
    for ((x) = (MAPFLAG_NAMES) 0; \
         (x) < NUM_MAPFLAGS; \
         (x) = (MAPFLAG_NAMES) ((int)(x)+1))
enum EVENTTYPE_NAMES
{
    EVENTTYPE_NONE = 0,
    EVENTTYPE_FORE = 1,
    EVENTTYPE_BACK = 2,
    EVENTTYPE_SYM = 4,
    EVENTTYPE_FORESYM = 5,
    EVENTTYPE_FOREBACK = 3,
    EVENTTYPE_ALL = 7,
    EVENTTYPE_SHOUT = 8,
    EVENTTYPE_LONG = 128,

    NUM_EVENTTYPES
};

#define FOREACH_EVENTTYPE(x) \
    for ((x) = (EVENTTYPE_NAMES) 0; \
         (x) < NUM_EVENTTYPES; \
         (x) = (EVENTTYPE_NAMES) ((int)(x)+1))
enum TILE_NAMES
{
    TILE_INVALID,
    TILE_NONE,
    TILE_PUSHER,
    TILE_STATUE,
    TILE_ALTAR,
    TILE_FLOOR,
    TILE_CARPET,
    TILE_CAVEFLOOR,
    TILE_MAZEFLOOR,
    TILE_DARKCAVEFLOOR,
    TILE_CHAIR,
    TILE_TABLE,
    TILE_DOWNSTAIRS,
    TILE_UPSTAIRS,
    TILE_SNOWYPATH,
    TILE_PATH,
    TILE_GRASS,
    TILE_DIRT,
    TILE_MEDITATIONSPOT,
    TILE_FIELD,
    TILE_FROZENFIELD,
    TILE_FIRE,
    TILE_TUNNELWALL,
    TILE_CORRIDORWALL,
    TILE_ICEWALL,
    TILE_WALL,
    TILE_STUCCOWALL,
    TILE_MAZEWALL,
    TILE_CAVEWALL,
    TILE_FUTURE_FORGE,
    TILE_WOODWALL,
    TILE_SOLIDWALL,
    TILE_PORTAL,
    TILE_ORANGEPORTAL,
    TILE_BLUEPORTAL,
    TILE_MOUNTAINPROTOPORTAL,
    TILE_PROTOPORTAL,
    TILE_USERPROTOPORTAL,
    TILE_BROKENWALL,
    TILE_DOOR_CLOSED,
    TILE_DOOR_OPEN,
    TILE_DOOR_BROKEN,
    TILE_DOOR_LOCKED_UNKNOWN,
    TILE_DOOR_JAMMED_UNKNOWN,
    TILE_DOOR_LOCKED,
    TILE_DOOR_JAMMED,
    TILE_DOOR_EMPTY,
    TILE_MAZEDOOR,
    TILE_SECRETDOOR,
    TILE_MOUNTAIN,
    TILE_ICEMOUNTAIN,
    TILE_SNOWYPASS,
    TILE_BRIDGE,
    TILE_WATER,
    TILE_ICE,
    TILE_BUSH,
    TILE_FOREST,
    TILE_BAREFOREST,

    NUM_TILES
};

#define FOREACH_TILE(x) \
    for ((x) = (TILE_NAMES) 0; \
         (x) < NUM_TILES; \
         (x) = (TILE_NAMES) ((int)(x)+1))
enum TERRAIN_NAMES
{
    TERRAIN_NONE,
    TERRAIN_PLAINS,
    TERRAIN_BUSHES,
    TERRAIN_FOREST,
    TERRAIN_WASTE,

    NUM_TERRAINS
};

#define FOREACH_TERRAIN(x) \
    for ((x) = (TERRAIN_NAMES) 0; \
         (x) < NUM_TERRAINS; \
         (x) = (TERRAIN_NAMES) ((int)(x)+1))
enum AI_NAMES
{
    AI_NONE,
    AI_STAYHOME,
    AI_HOME,
    AI_CHARGE,
    AI_RAT,
    AI_STRAIGHTLINE,
    AI_PATHTO,
    AI_ORTHO,
    AI_FLANK,
    AI_RANGECOWARD,
    AI_COWARD,
    AI_MOUSE,
    AI_PEACEFUL,
    AI_ADVENTURER,
    AI_ORC,

    NUM_AIS
};

#define FOREACH_AI(x) \
    for ((x) = (AI_NAMES) 0; \
         (x) < NUM_AIS; \
         (x) = (AI_NAMES) ((int)(x)+1))
enum DISTRIBUTION_NAMES
{
    DISTRIBUTION_CONSTANT,
    DISTRIBUTION_GAUSSIAN,
    DISTRIBUTION_UNIFORM,
    DISTRIBUTION_BIMODAL,

    NUM_DISTRIBUTIONS
};

#define FOREACH_DISTRIBUTION(x) \
    for ((x) = (DISTRIBUTION_NAMES) 0; \
         (x) < NUM_DISTRIBUTIONS; \
         (x) = (DISTRIBUTION_NAMES) ((int)(x)+1))
enum ATTACK_NAMES
{
    ATTACK_NONE,
    ATTACK_KICK,
    ATTACK_BROKEN,
    ATTACK_ADHOC34,
    ATTACK_ADHOC36,
    ATTACK_ADHOC38,
    ATTACK_ADHOC40,
    ATTACK_ADHOC41,
    ATTACK_ADHOC42,
    ATTACK_ADHOC43,
    ATTACK_ADHOC44,
    ATTACK_ADHOC46,
    ATTACK_ADHOC47,
    ATTACK_ADHOC48,
    ATTACK_ADHOC49,
    ATTACK_ADHOC50,
    ATTACK_ADHOC51,
    ATTACK_ADHOC52,
    ATTACK_ADHOC53,
    ATTACK_ADHOC54,
    ATTACK_ADHOC55,
    ATTACK_ADHOC56,
    ATTACK_ADHOC57,
    ATTACK_ADHOC62,
    ATTACK_ADHOC67,
    ATTACK_ADHOC73,
    ATTACK_ADHOC81,
    ATTACK_ADHOC97,
    ATTACK_ADHOC110,
    ATTACK_ADHOC123,
    ATTACK_ADHOC124,
    ATTACK_ADHOC125,
    ATTACK_ADHOC126,
    ATTACK_ADHOC127,
    ATTACK_ADHOC133,
    ATTACK_ADHOC154,
    ATTACK_ADHOC156,
    ATTACK_ADHOC157,
    ATTACK_ADHOC160,
    ATTACK_ADHOC161,
    ATTACK_ADHOC162,
    ATTACK_ADHOC163,
    ATTACK_ADHOC164,
    ATTACK_ADHOC165,
    ATTACK_ADHOC166,
    ATTACK_ADHOC167,
    ATTACK_ADHOC168,
    ATTACK_ADHOC169,
    ATTACK_ADHOC172,
    ATTACK_ADHOC173,
    ATTACK_ADHOC175,
    ATTACK_ADHOC176,
    ATTACK_ADHOC178,
    ATTACK_ADHOC179,
    ATTACK_ADHOC180,
    ATTACK_ADHOC181,
    ATTACK_ADHOC182,
    ATTACK_ADHOC183,
    ATTACK_ADHOC184,
    ATTACK_ADHOC185,
    ATTACK_ADHOC186,
    ATTACK_ADHOC187,
    ATTACK_ADHOC188,
    ATTACK_ADHOC189,
    ATTACK_ADHOC190,
    ATTACK_ADHOC191,
    ATTACK_ADHOC192,
    ATTACK_ADHOC193,
    ATTACK_ADHOC220,
    ATTACK_ADHOC222,
    ATTACK_ADHOC224,
    ATTACK_ADHOC226,
    ATTACK_ADHOC228,
    ATTACK_ADHOC229,
    ATTACK_ADHOC230,

    NUM_ATTACKS
};

#define FOREACH_ATTACK(x) \
    for ((x) = (ATTACK_NAMES) 0; \
         (x) < NUM_ATTACKS; \
         (x) = (ATTACK_NAMES) ((int)(x)+1))
enum ITEMLIST_NAMES
{
    ITEMLIST_NONE,
    ITEMLIST_ADHOC6,
    ITEMLIST_STARTER_AVATAR,
    ITEMLIST_ADHOC7,
    ITEMLIST_ADHOC8,
    ITEMLIST_ADHOC9,
    ITEMLIST_ADHOC10,
    ITEMLIST_ADHOC11,
    ITEMLIST_ADHOC12,
    ITEMLIST_WIZARD,
    ITEMLIST_ADHOC13,
    ITEMLIST_ADHOC14,
    ITEMLIST_ADHOC15,
    ITEMLIST_ADHOC16,
    ITEMLIST_THIEF,
    ITEMLIST_ADHOC17,
    ITEMLIST_ADHOC18,
    ITEMLIST_ADHOC19,
    ITEMLIST_FIGHTER,
    ITEMLIST_GOLD,
    ITEMLIST_ADHOC20,
    ITEMLIST_BOW_AND_GOLD,
    ITEMLIST_ADHOC23,
    ITEMLIST_ADHOC24,
    ITEMLIST_ADHOC25,
    ITEMLIST_ADHOC26,
    ITEMLIST_ADHOC27,
    ITEMLIST_ADHOC28,
    ITEMLIST_ADHOC29,
    ITEMLIST_ADHOC30,
    ITEMLIST_ADHOC58,
    ITEMLIST_ADHOC59,
    ITEMLIST_ADHOC63,
    ITEMLIST_ADHOC64,
    ITEMLIST_ADHOC65,
    ITEMLIST_ADHOC68,
    ITEMLIST_ADHOC69,
    ITEMLIST_ADHOC70,
    ITEMLIST_ADHOC71,
    ITEMLIST_ADHOC74,
    ITEMLIST_ADHOC75,
    ITEMLIST_ADHOC76,
    ITEMLIST_ADHOC77,
    ITEMLIST_ADHOC78,
    ITEMLIST_ADHOC79,
    ITEMLIST_ADHOC82,
    ITEMLIST_ADHOC83,
    ITEMLIST_ADHOC84,
    ITEMLIST_ADHOC85,
    ITEMLIST_ADHOC86,
    ITEMLIST_ADHOC87,
    ITEMLIST_ADHOC88,
    ITEMLIST_ADHOC89,
    ITEMLIST_ADHOC90,
    ITEMLIST_ADHOC91,
    ITEMLIST_ADHOC98,
    ITEMLIST_ADHOC99,
    ITEMLIST_ADHOC100,
    ITEMLIST_ADHOC101,
    ITEMLIST_ADHOC102,
    ITEMLIST_ADHOC103,
    ITEMLIST_ADHOC104,
    ITEMLIST_ADHOC105,
    ITEMLIST_ADHOC111,
    ITEMLIST_ADHOC112,
    ITEMLIST_ADHOC113,
    ITEMLIST_ADHOC114,
    ITEMLIST_ADHOC115,
    ITEMLIST_ADHOC116,
    ITEMLIST_ADHOC117,
    ITEMLIST_ADHOC118,
    ITEMLIST_ADHOC128,
    ITEMLIST_ADHOC129,
    ITEMLIST_ADHOC130,
    ITEMLIST_ADHOC131,
    ITEMLIST_ADHOC134,
    ITEMLIST_ADHOC135,
    ITEMLIST_ADHOC136,
    ITEMLIST_ADHOC137,
    ITEMLIST_ADHOC138,
    ITEMLIST_ADHOC139,
    ITEMLIST_ADHOC140,
    ITEMLIST_ADHOC141,
    ITEMLIST_ADHOC142,
    ITEMLIST_ADHOC143,
    ITEMLIST_ADHOC144,
    ITEMLIST_ADHOC145,
    ITEMLIST_ADHOC146,
    ITEMLIST_ADHOC147,
    ITEMLIST_ADHOC148,
    ITEMLIST_ADHOC158,

    NUM_ITEMLISTS
};

#define FOREACH_ITEMLIST(x) \
    for ((x) = (ITEMLIST_NAMES) 0; \
         (x) < NUM_ITEMLISTS; \
         (x) = (ITEMLIST_NAMES) ((int)(x)+1))
enum STARTITEMS_NAMES
{
    STARTITEMS_NONE,
    STARTITEMS_ADHOC21,
    STARTITEMS_ADHOC22,
    STARTITEMS_AVATAR,
    STARTITEMS_ADHOC31,
    STARTITEMS_ADHOC32,
    STARTITEMS_ADHOC33,
    STARTITEMS_KOBOLD,
    STARTITEMS_ADHOC35,
    STARTITEMS_ADHOC37,
    STARTITEMS_ADHOC39,
    STARTITEMS_ADHOC60,
    STARTITEMS_ADHOC61,
    STARTITEMS_ADHOC66,
    STARTITEMS_ADHOC72,
    STARTITEMS_ADHOC80,
    STARTITEMS_ADHOC92,
    STARTITEMS_ADHOC93,
    STARTITEMS_ADHOC94,
    STARTITEMS_ADHOC95,
    STARTITEMS_ADHOC96,
    STARTITEMS_ADHOC106,
    STARTITEMS_ADHOC107,
    STARTITEMS_ADHOC108,
    STARTITEMS_ADHOC109,
    STARTITEMS_ADHOC119,
    STARTITEMS_ADHOC120,
    STARTITEMS_ADHOC121,
    STARTITEMS_ADHOC122,
    STARTITEMS_ADHOC132,
    STARTITEMS_ADHOC149,
    STARTITEMS_ADHOC150,
    STARTITEMS_ADHOC151,
    STARTITEMS_ADHOC152,
    STARTITEMS_ADHOC153,
    STARTITEMS_ADHOC159,

    NUM_STARTITEMSS
};

#define FOREACH_STARTITEMS(x) \
    for ((x) = (STARTITEMS_NAMES) 0; \
         (x) < NUM_STARTITEMSS; \
         (x) = (STARTITEMS_NAMES) ((int)(x)+1))
enum MOB_NAMES
{
    MOB_NONE,
    MOB_AVATAR_WIZARD,
    MOB_AVATAR_THIEF,
    MOB_AVATAR_FIGHTER,
    MOB_RAT,
    MOB_BAT,
    MOB_VAMPIREBAT,
    MOB_SLUG,
    MOB_ACIDSLUG,
    MOB_DEATHSLUG,
    MOB_TRIDUDE,
    MOB_IMP,
    MOB_DEVIL,
    MOB_DOG,
    MOB_GUARDDOG,
    MOB_WOLF,
    MOB_ICEWOLF,
    MOB_SERVANT,
    MOB_GUARD,
    MOB_ARCHER,
    MOB_THIEF,
    MOB_ASSASSIN,
    MOB_SERGEANT,
    MOB_CAPTAIN,
    MOB_ELITEGUARD,
    MOB_SKELETON,
    MOB_ZOMBIE,
    MOB_GHOST,
    MOB_KOBOLD,
    MOB_KOBOLD_THIEF,
    MOB_ORC,
    MOB_TROLL,
    MOB_VAMPIRE,
    MOB_GIANT,
    MOB_WHITEDRAGON,
    MOB_BLACKDRAGON,
    MOB_BLUEDRAGON,
    MOB_REDDRAGON,
    MOB_GREENDRAGON,
    MOB_GRIDBUG,
    MOB_CAVESPIDER,
    MOB_FIREANT,
    MOB_GIANTSPIDER,
    MOB_BAEZLBUB,

    NUM_MOBS
};

#define FOREACH_MOB(x) \
    for ((x) = (MOB_NAMES) 0; \
         (x) < NUM_MOBS; \
         (x) = (MOB_NAMES) ((int)(x)+1))
enum ARMOURSLOT_NAMES
{
    ARMOURSLOT_NONE,
    ARMOURSLOT_BODY,

    NUM_ARMOURSLOTS
};

#define FOREACH_ARMOURSLOT(x) \
    for ((x) = (ARMOURSLOT_NAMES) 0; \
         (x) < NUM_ARMOURSLOTS; \
         (x) = (ARMOURSLOT_NAMES) ((int)(x)+1))
enum ITEMCLASS_NAMES
{
    ITEMCLASS_NONE,
    ITEMCLASS_MELEEWEAPON,
    ITEMCLASS_RANGEWEAPON,
    ITEMCLASS_AMMO,
    ITEMCLASS_TOOL,
    ITEMCLASS_ARMOUR,
    ITEMCLASS_POTION,
    ITEMCLASS_SCROLL,
    ITEMCLASS_SPELLBOOK,
    ITEMCLASS_RING,
    ITEMCLASS_FOOD,
    ITEMCLASS_FURNITURE,
    ITEMCLASS_TREASURE,

    NUM_ITEMCLASSS
};

#define FOREACH_ITEMCLASS(x) \
    for ((x) = (ITEMCLASS_NAMES) 0; \
         (x) < NUM_ITEMCLASSS; \
         (x) = (ITEMCLASS_NAMES) ((int)(x)+1))
enum ITEM_NAMES
{
    ITEM_NONE,
    ITEM_DAGGER,
    ITEM_SHORTSWORD,
    ITEM_LONGSWORD,
    ITEM_GREATAXE,
    ITEM_CLUB,
    ITEM_MACE,
    ITEM_WARHAMMER,
    ITEM_SPEAR,
    ITEM_ARROW,
    ITEM_ROCK,
    ITEM_BOULDER,
    ITEM_BOW,
    ITEM_SLING,
    ITEM_ROBES,
    ITEM_LEATHER,
    ITEM_STUDDEDLEATHER,
    ITEM_RINGMAIL,
    ITEM_CHAINMAIL,
    ITEM_SCALEMAIL,
    ITEM_PLATEMAIL,
    ITEM_FULLPLATE,
    ITEM_PICKAXE,
    ITEM_LOCKPICK,
    ITEM_WRITINGSET,
    ITEM_MEATCHUNK,
    ITEM_COOKED_MEATCHUNK,
    ITEM_APPLE,
    ITEM_BISCUIT,
    ITEM_MUSHROOM,
    ITEM_SAUSAGES,
    ITEM_RATION,
    ITEM_CHAIR,
    ITEM_TABLE,
    ITEM_SHELF,
    ITEM_BED,
    ITEM_STATUE,
    ITEM_MACGUFFIN,
    ITEM_MIDAS_WAND,
    ITEM_KNOWLEDGE_ORB,
    ITEM_STEEL_CLOAK,
    ITEM_CORPSE,
    ITEM_COIN,
    ITEM_EMERALD,
    ITEM_SAPPHIRE,
    ITEM_DIAMOND,
    ITEM_AMETHYST,
    ITEM_TOPAZ,
    ITEM_QUICKBOOST,
    ITEM_HASTED,
    ITEM_BLIND,
    ITEM_CHOKING,
    ITEM_ENRAGED,
    ITEM_POISON,
    ITEM_REGEN,
    ITEM_RESIST,
    ITEM_VULNERABLE,
    ITEM_PLAGUE,
    ITEM_SLOW,
    ITEM_INVULNERABLE,
    ITEM_ASLEEP,
    ITEM_RING_RUBY,
    ITEM_RING_SAPPHIRE,
    ITEM_RING_GOLD,
    ITEM_RING_AMETHYST,
    ITEM_RING_DIAMOND,
    ITEM_SCROLL_BLANK,
    ITEM_SCROLL_XYZZY,
    ITEM_SCROLL_FOOBAR,
    ITEM_SCROLL_HELLOWORLD,
    ITEM_SCROLL_ABRACADABRA,
    ITEM_SCROLL_PLUGH,
    ITEM_SCROLL_XYLOTOMOUS,
    ITEM_SCROLL_README,
    ITEM_SPELLBOOK_BLANK,
    ITEM_SPELLBOOK_RED,
    ITEM_SPELLBOOK_GREEN,
    ITEM_SPELLBOOK_ORANGE,
    ITEM_SPELLBOOK_YELLOW,
    ITEM_SPELLBOOK_WHITE,
    ITEM_SPELLBOOK_GLOWING,
    ITEM_SPELLBOOK_CYAN,
    ITEM_SPELLBOOK_GREY,
    ITEM_SPELLBOOK_PURPLE,
    ITEM_SPELLBOOK_BLUE,
    ITEM_SPELLBOOK_LEATHER,
    ITEM_SPELLBOOK_BLOODY,
    ITEM_SPELLBOOK_GILT,
    ITEM_POTION_RED,
    ITEM_POTION_YELLOW,
    ITEM_POTION_ORANGE,
    ITEM_POTION_GREEN,
    ITEM_POTION_BLUE,
    ITEM_POTION_PURPLE,
    ITEM_POTION_WHITE,
    ITEM_POTION_GLOWING,
    ITEM_POTION_CYAN,
    ITEM_POTION_PINK,

    NUM_ITEMS
};

#define FOREACH_ITEM(x) \
    for ((x) = (ITEM_NAMES) 0; \
         (x) < NUM_ITEMS; \
         (x) = (ITEM_NAMES) ((int)(x)+1))
enum SCROLL_NAMES
{
    SCROLL_NONE,
    SCROLL_FIRE,
    SCROLL_IDENTIFY,
    SCROLL_TELEPORT,
    SCROLL_ENCHANT_WEAPON,
    SCROLL_ENCHANT_ARMOUR,
    SCROLL_MAP,
    SCROLL_SUMMON,

    NUM_SCROLLS
};

#define FOREACH_SCROLL(x) \
    for ((x) = (SCROLL_NAMES) 0; \
         (x) < NUM_SCROLLS; \
         (x) = (SCROLL_NAMES) ((int)(x)+1))
enum SPELL_NAMES
{
    SPELL_NONE,
    SPELL_MAGICMISSILE,
    SPELL_TELEPORT,
    SPELL_TSUNAMI,
    SPELL_FORCEBOLT,
    SPELL_ICEWALL,
    SPELL_DISINTEGRATE,
    SPELL_COLOURSPRAY,
    SPELL_CURE,
    SPELL_SLEEP,
    SPELL_LIGHTNINGBOLT,
    SPELL_SHOCK,
    SPELL_POISONCLOUD,
    SPELL_FIREBALL,

    NUM_SPELLS
};

#define FOREACH_SPELL(x) \
    for ((x) = (SPELL_NAMES) 0; \
         (x) < NUM_SPELLS; \
         (x) = (SPELL_NAMES) ((int)(x)+1))
enum RING_NAMES
{
    RING_NONE,
    RING_ACID,
    RING_ICE,
    RING_FIRE,
    RING_HEALTH,
    RING_ELECTRIC,

    NUM_RINGS
};

#define FOREACH_RING(x) \
    for ((x) = (RING_NAMES) 0; \
         (x) < NUM_RINGS; \
         (x) = (RING_NAMES) ((int)(x)+1))
enum POTION_NAMES
{
    POTION_NONE,
    POTION_WATER,
    POTION_SPEED,
    POTION_HEAL,
    POTION_GREATERHEAL,
    POTION_ACIDVULN,
    POTION_ACIDRESIST,
    POTION_ACID,
    POTION_POISON,
    POTION_CURE,
    POTION_SLEEP,

    NUM_POTIONS
};

#define FOREACH_POTION(x) \
    for ((x) = (POTION_NAMES) 0; \
         (x) < NUM_POTIONS; \
         (x) = (POTION_NAMES) ((int)(x)+1))
enum MATERIAL_NAMES
{
    MATERIAL_NONE,
    MATERIAL_WOOD,
    MATERIAL_STONE,
    MATERIAL_IRON,
    MATERIAL_SILVER,
    MATERIAL_GOLD,

    NUM_MATERIALS
};

#define FOREACH_MATERIAL(x) \
    for ((x) = (MATERIAL_NAMES) 0; \
         (x) < NUM_MATERIALS; \
         (x) = (MATERIAL_NAMES) ((int)(x)+1))
enum TRAP_NAMES
{
    TRAP_NONE,
    TRAP_FLASH,
    TRAP_POISON,
    TRAP_SLEEP,
    TRAP_TRIPWIRE,
    TRAP_POISON_DART,
    TRAP_DART,
    TRAP_FIRE,

    NUM_TRAPS
};

#define FOREACH_TRAP(x) \
    for ((x) = (TRAP_NAMES) 0; \
         (x) < NUM_TRAPS; \
         (x) = (TRAP_NAMES) ((int)(x)+1))
enum KEY_NAMES
{
    KEY_MOVE_N,
    KEY_MOVE_NE,
    KEY_MOVE_NW,
    KEY_MOVE_S,
    KEY_MOVE_SE,
    KEY_MOVE_SW,
    KEY_MOVE_STAY,
    KEY_MOVE_E,
    KEY_MOVE_W,
    KEY_INVENTORY,
    KEY_INTRINSICS,
    KEY_OPTIONS,
    KEY_QUIT,
    KEY_RELOAD,
    KEY_PICKUP,
    KEY_PICKUP2,
    KEY_PICKUPSPECIFIC,
    KEY_EXAMINE,
    KEY_LOOKAROUND,
    KEY_CHAMBERSCAN,
    KEY_SEARCH,
    KEY_FIRE,
    KEY_READYRANGED,
    KEY_CLOSE,
    KEY_CLIMBUP,
    KEY_CLIMBDOWN,
    KEY_OPEN,
    KEY_THROW,
    KEY_EAT,
    KEY_QUAFF,
    KEY_READWRITING,
    KEY_DROP,
    KEY_DROPALL,
    KEY_ENHANCE,
    KEY_FORGET,
    KEY_WIELD,
    KEY_WEAR,
    KEY_TAKEOFF,
    KEY_CAST,
    KEY_KICK,
    KEY_MEDITATE,
    KEY_APPLY,
    KEY_STATUS,
    KEY_WORLDSHIFT,

    NUM_KEYS
};

#define FOREACH_KEY(x) \
    for ((x) = (KEY_NAMES) 0; \
         (x) < NUM_KEYS; \
         (x) = (KEY_NAMES) ((int)(x)+1))
struct WORLD_DEF
{
    const char * name;
    int font;
    MOB_NAMES avatar;
    ROOMTYPE_NAMES roomtype;
    ROOMTYPE_NAMES finalroom;
    ITEM_NAMES macguffin;


    void reset()
    {
        name = "Rogue";
        font = 0;
        avatar = MOB_NONE;
        roomtype = ROOMTYPE_MAGE;
        finalroom = ROOMTYPE_WIZARD_FINAL;
        macguffin = ITEM_MACGUFFIN;

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    font " << lcl_savedata(font).buffer() << "\n";
        os << "    avatar " << lcl_savedata((int)avatar).buffer() << "\n";
        os << "    roomtype " << lcl_savedata((int)roomtype).buffer() << "\n";
        os << "    finalroom " << lcl_savedata((int)finalroom).buffer() << "\n";
        os << "    macguffin " << lcl_savedata((int)macguffin).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("font"))
                    lcl_loaddata(_value, font);
                if (!_name.strcmp("avatar"))
                    { int tmp; lcl_loaddata(_value, tmp); avatar = (MOB_NAMES) tmp; }
                if (!_name.strcmp("roomtype"))
                    { int tmp; lcl_loaddata(_value, tmp); roomtype = (ROOMTYPE_NAMES) tmp; }
                if (!_name.strcmp("finalroom"))
                    { int tmp; lcl_loaddata(_value, tmp); finalroom = (ROOMTYPE_NAMES) tmp; }
                if (!_name.strcmp("macguffin"))
                    { int tmp; lcl_loaddata(_value, tmp); macguffin = (ITEM_NAMES) tmp; }

            }
            else
                break;
        }
    }


};

extern const WORLD_DEF glb_worlddefs[];

struct WORLDLIST_DEF
{
    WORLD_NAMES world;
    WORLDLIST_NAMES next;


    void reset()
    {
        world = WORLD_THIEF;
        next = WORLDLIST_NONE;

    }

    void saveData(ostream &os) const
    {
        os << "    world " << lcl_savedata((int)world).buffer() << "\n";
        os << "    next " << lcl_savedata((int)next).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("world"))
                    { int tmp; lcl_loaddata(_value, tmp); world = (WORLD_NAMES) tmp; }
                if (!_name.strcmp("next"))
                    { int tmp; lcl_loaddata(_value, tmp); next = (WORLDLIST_NAMES) tmp; }

            }
            else
                break;
        }
    }


};

extern const WORLDLIST_DEF glb_worldlistdefs[];

struct ROLE_DEF
{
    const char * name;


    void reset()
    {
        name = "job";

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);

            }
            else
                break;
        }
    }


};

extern const ROLE_DEF glb_roledefs[];

struct ROLELIST_DEF
{
    ROLE_NAMES role;
    ROLELIST_NAMES next;


    void reset()
    {
        role = ROLE_NONE;
        next = ROLELIST_NONE;

    }

    void saveData(ostream &os) const
    {
        os << "    role " << lcl_savedata((int)role).buffer() << "\n";
        os << "    next " << lcl_savedata((int)next).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("role"))
                    { int tmp; lcl_loaddata(_value, tmp); role = (ROLE_NAMES) tmp; }
                if (!_name.strcmp("next"))
                    { int tmp; lcl_loaddata(_value, tmp); next = (ROLELIST_NAMES) tmp; }

            }
            else
                break;
        }
    }


};

extern const ROLELIST_DEF glb_rolelistdefs[];

struct STRATEGY_DEF
{
    const char * name;


    void reset()
    {
        name = "lemur";

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);

            }
            else
                break;
        }
    }


};

extern const STRATEGY_DEF glb_strategydefs[];

struct HEALTHLEVEL_DEF
{
    const char * normal;
    const char * construct;
    ATTR_NAMES attr;


    void reset()
    {
        normal = "at nominal health";
        construct = "operational";
        attr = ATTR_NORMAL;

    }

    void saveData(ostream &os) const
    {
        os << "    normal " << lcl_savedata(normal).buffer() << "\n";
        os << "    construct " << lcl_savedata(construct).buffer() << "\n";
        os << "    attr " << lcl_savedata((int)attr).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("normal"))
                    lcl_loaddata(_value, normal);
                if (!_name.strcmp("construct"))
                    lcl_loaddata(_value, construct);
                if (!_name.strcmp("attr"))
                    { int tmp; lcl_loaddata(_value, tmp); attr = (ATTR_NAMES) tmp; }

            }
            else
                break;
        }
    }


};

extern const HEALTHLEVEL_DEF glb_healthleveldefs[];

struct FOODLEVEL_DEF
{
    const char * normal;
    ATTR_NAMES attr;


    void reset()
    {
        normal = "peckish";
        attr = ATTR_NORMAL;

    }

    void saveData(ostream &os) const
    {
        os << "    normal " << lcl_savedata(normal).buffer() << "\n";
        os << "    attr " << lcl_savedata((int)attr).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("normal"))
                    lcl_loaddata(_value, normal);
                if (!_name.strcmp("attr"))
                    { int tmp; lcl_loaddata(_value, tmp); attr = (ATTR_NAMES) tmp; }

            }
            else
                break;
        }
    }


};

extern const FOODLEVEL_DEF glb_foodleveldefs[];

struct SOLDIER_DEF
{


    void reset()
    {

    }

    void saveData(ostream &os) const
    {

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);

            }
            else
                break;
        }
    }


};

extern const SOLDIER_DEF glb_soldierdefs[];

struct PHASE_DEF
{


    void reset()
    {

    }

    void saveData(ostream &os) const
    {

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);

            }
            else
                break;
        }
    }


};

extern const PHASE_DEF glb_phasedefs[];

struct SIZE_DEF
{
    const char * name;
    int weight;


    void reset()
    {
        name = "unusual";
        weight = 0;

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    weight " << lcl_savedata(weight).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("weight"))
                    lcl_loaddata(_value, weight);

            }
            else
                break;
        }
    }


};

extern const SIZE_DEF glb_sizedefs[];

struct EFFECTCLASS_DEF
{


    void reset()
    {

    }

    void saveData(ostream &os) const
    {

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);

            }
            else
                break;
        }
    }


};

extern const EFFECTCLASS_DEF glb_effectclassdefs[];

struct EFFECT_DEF
{
    EFFECTCLASS_NAMES type;
    ELEMENT_NAMES element;
    DICE duration;
    DICE amount;
    ITEM_NAMES itemflag;
    ITEM_NAMES itemresist;
    EFFECT_NAMES next;


    void reset()
    {
        type = EFFECTCLASS_NONE;
        element = ELEMENT_NONE;
        duration = DICE{ 0, 0, 0 };
        amount = DICE{ 0, 0, 0 };
        itemflag = ITEM_NONE;
        itemresist = ITEM_NONE;
        next = EFFECT_NONE;

    }

    void saveData(ostream &os) const
    {
        os << "    type " << lcl_savedata((int)type).buffer() << "\n";
        os << "    element " << lcl_savedata((int)element).buffer() << "\n";
        os << "    duration " << lcl_savedata(duration).buffer() << "\n";
        os << "    amount " << lcl_savedata(amount).buffer() << "\n";
        os << "    itemflag " << lcl_savedata((int)itemflag).buffer() << "\n";
        os << "    itemresist " << lcl_savedata((int)itemresist).buffer() << "\n";
        os << "    next " << lcl_savedata((int)next).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("type"))
                    { int tmp; lcl_loaddata(_value, tmp); type = (EFFECTCLASS_NAMES) tmp; }
                if (!_name.strcmp("element"))
                    { int tmp; lcl_loaddata(_value, tmp); element = (ELEMENT_NAMES) tmp; }
                if (!_name.strcmp("duration"))
                    lcl_loaddata(_value, duration);
                if (!_name.strcmp("amount"))
                    lcl_loaddata(_value, amount);
                if (!_name.strcmp("itemflag"))
                    { int tmp; lcl_loaddata(_value, tmp); itemflag = (ITEM_NAMES) tmp; }
                if (!_name.strcmp("itemresist"))
                    { int tmp; lcl_loaddata(_value, tmp); itemresist = (ITEM_NAMES) tmp; }
                if (!_name.strcmp("next"))
                    { int tmp; lcl_loaddata(_value, tmp); next = (EFFECT_NAMES) tmp; }

            }
            else
                break;
        }
    }


};

extern const EFFECT_DEF glb_effectdefs[];

struct ELEMENT_DEF
{
    const char * name;
    u8 symbol;
    ATTR_NAMES attr;
    const char * damageverb;


    void reset()
    {
        name = "ether";
        symbol = '0';
        attr = ATTR_CYAN;
        damageverb = "disintegrate";

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    symbol " << lcl_savedata(symbol).buffer() << "\n";
        os << "    attr " << lcl_savedata((int)attr).buffer() << "\n";
        os << "    damageverb " << lcl_savedata(damageverb).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("symbol"))
                    lcl_loaddata(_value, symbol);
                if (!_name.strcmp("attr"))
                    { int tmp; lcl_loaddata(_value, tmp); attr = (ATTR_NAMES) tmp; }
                if (!_name.strcmp("damageverb"))
                    lcl_loaddata(_value, damageverb);

            }
            else
                break;
        }
    }


};

extern const ELEMENT_DEF glb_elementdefs[];

struct DAMAGECLASS_DEF
{
    const char * name;


    void reset()
    {
        name = "misc";

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);

            }
            else
                break;
        }
    }


};

extern const DAMAGECLASS_DEF glb_damageclassdefs[];

struct ATTACKSTYLE_DEF
{


    void reset()
    {

    }

    void saveData(ostream &os) const
    {

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);

            }
            else
                break;
        }
    }


};

extern const ATTACKSTYLE_DEF glb_attackstyledefs[];

struct CHAMBER_DEF
{
    const char * descr;


    void reset()
    {
        descr = "between rooms";

    }

    void saveData(ostream &os) const
    {
        os << "    descr " << lcl_savedata(descr).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("descr"))
                    lcl_loaddata(_value, descr);

            }
            else
                break;
        }
    }


};

extern const CHAMBER_DEF glb_chamberdefs[];

struct ROOMTYPE_DEF
{
    const char * prefix;
    bool randomorient;
    bool allowportal;
    bool usegenerator;
    bool hastraps;
    TILE_NAMES wall_tile;
    TILE_NAMES floor_tile;
    TILE_NAMES path_tile;
    TILE_NAMES door_tile;
    TILE_NAMES tunnelwall_tile;
    const char * name;
    bool deadend;


    void reset()
    {
        prefix = "";
        randomorient = true;
        allowportal = true;
        usegenerator = false;
        hastraps = false;
        wall_tile = TILE_WALL;
        floor_tile = TILE_FLOOR;
        path_tile = TILE_PATH;
        door_tile = TILE_DOOR_CLOSED;
        tunnelwall_tile = TILE_TUNNELWALL;
        name = "room";
        deadend = false;

    }

    void saveData(ostream &os) const
    {
        os << "    prefix " << lcl_savedata(prefix).buffer() << "\n";
        os << "    randomorient " << lcl_savedata(randomorient).buffer() << "\n";
        os << "    allowportal " << lcl_savedata(allowportal).buffer() << "\n";
        os << "    usegenerator " << lcl_savedata(usegenerator).buffer() << "\n";
        os << "    hastraps " << lcl_savedata(hastraps).buffer() << "\n";
        os << "    wall_tile " << lcl_savedata((int)wall_tile).buffer() << "\n";
        os << "    floor_tile " << lcl_savedata((int)floor_tile).buffer() << "\n";
        os << "    path_tile " << lcl_savedata((int)path_tile).buffer() << "\n";
        os << "    door_tile " << lcl_savedata((int)door_tile).buffer() << "\n";
        os << "    tunnelwall_tile " << lcl_savedata((int)tunnelwall_tile).buffer() << "\n";
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    deadend " << lcl_savedata(deadend).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("prefix"))
                    lcl_loaddata(_value, prefix);
                if (!_name.strcmp("randomorient"))
                    lcl_loaddata(_value, randomorient);
                if (!_name.strcmp("allowportal"))
                    lcl_loaddata(_value, allowportal);
                if (!_name.strcmp("usegenerator"))
                    lcl_loaddata(_value, usegenerator);
                if (!_name.strcmp("hastraps"))
                    lcl_loaddata(_value, hastraps);
                if (!_name.strcmp("wall_tile"))
                    { int tmp; lcl_loaddata(_value, tmp); wall_tile = (TILE_NAMES) tmp; }
                if (!_name.strcmp("floor_tile"))
                    { int tmp; lcl_loaddata(_value, tmp); floor_tile = (TILE_NAMES) tmp; }
                if (!_name.strcmp("path_tile"))
                    { int tmp; lcl_loaddata(_value, tmp); path_tile = (TILE_NAMES) tmp; }
                if (!_name.strcmp("door_tile"))
                    { int tmp; lcl_loaddata(_value, tmp); door_tile = (TILE_NAMES) tmp; }
                if (!_name.strcmp("tunnelwall_tile"))
                    { int tmp; lcl_loaddata(_value, tmp); tunnelwall_tile = (TILE_NAMES) tmp; }
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("deadend"))
                    lcl_loaddata(_value, deadend);

            }
            else
                break;
        }
    }


};

extern const ROOMTYPE_DEF glb_roomtypedefs[];

struct LEVEL_DEF
{
    int numcreated;
    ROOMTYPE_NAMES roomtype;


    void reset()
    {
        numcreated = 0;
        roomtype = ROOMTYPE_MAGE;

    }

    void saveData(ostream &os) const
    {
        os << "    numcreated " << lcl_savedata(numcreated).buffer() << "\n";
        os << "    roomtype " << lcl_savedata((int)roomtype).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("numcreated"))
                    lcl_loaddata(_value, numcreated);
                if (!_name.strcmp("roomtype"))
                    { int tmp; lcl_loaddata(_value, tmp); roomtype = (ROOMTYPE_NAMES) tmp; }

            }
            else
                break;
        }
    }


};

extern const LEVEL_DEF glb_leveldefs[];

struct GAMERULES_DEF
{
    int bosslevel;


    void reset()
    {
        bosslevel = 10;

    }

    void saveData(ostream &os) const
    {
        os << "    bosslevel " << lcl_savedata(bosslevel).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("bosslevel"))
                    lcl_loaddata(_value, bosslevel);

            }
            else
                break;
        }
    }


};

extern const GAMERULES_DEF glb_gamerulesdefs[];

struct YELL_DEF
{


    void reset()
    {

    }

    void saveData(ostream &os) const
    {

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);

            }
            else
                break;
        }
    }


};

extern const YELL_DEF glb_yelldefs[];

struct HELP_DEF
{
    const char * name;
    u8 key;


    void reset()
    {
        name = "None";
        key = ' ';

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    key " << lcl_savedata(key).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("key"))
                    lcl_loaddata(_value, key);

            }
            else
                break;
        }
    }


};

extern const HELP_DEF glb_helpdefs[];

struct OPTION_DEF
{
    const char * name;
    u8 key;


    void reset()
    {
        name = "None";
        key = ' ';

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    key " << lcl_savedata(key).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("key"))
                    lcl_loaddata(_value, key);

            }
            else
                break;
        }
    }


};

extern const OPTION_DEF glb_optiondefs[];

struct ACTION_DEF
{


    void reset()
    {

    }

    void saveData(ostream &os) const
    {

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);

            }
            else
                break;
        }
    }


};

extern const ACTION_DEF glb_actiondefs[];

struct GOSSIP_DEF
{
    const char * name;


    void reset()
    {
        name = "none";

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);

            }
            else
                break;
        }
    }


};

extern const GOSSIP_DEF glb_gossipdefs[];

struct ATTR_DEF
{
    u8 bg_r;
    u8 bg_g;
    u8 bg_b;
    u8 fg_r;
    u8 fg_g;
    u8 fg_b;
    bool pulse;


    void reset()
    {
        bg_r = 0;
        bg_g = 0;
        bg_b = 0;
        fg_r = 255;
        fg_g = 255;
        fg_b = 255;
        pulse = false;

    }

    void saveData(ostream &os) const
    {
        os << "    bg_r " << lcl_savedata(bg_r).buffer() << "\n";
        os << "    bg_g " << lcl_savedata(bg_g).buffer() << "\n";
        os << "    bg_b " << lcl_savedata(bg_b).buffer() << "\n";
        os << "    fg_r " << lcl_savedata(fg_r).buffer() << "\n";
        os << "    fg_g " << lcl_savedata(fg_g).buffer() << "\n";
        os << "    fg_b " << lcl_savedata(fg_b).buffer() << "\n";
        os << "    pulse " << lcl_savedata(pulse).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("bg_r"))
                    lcl_loaddata(_value, bg_r);
                if (!_name.strcmp("bg_g"))
                    lcl_loaddata(_value, bg_g);
                if (!_name.strcmp("bg_b"))
                    lcl_loaddata(_value, bg_b);
                if (!_name.strcmp("fg_r"))
                    lcl_loaddata(_value, fg_r);
                if (!_name.strcmp("fg_g"))
                    lcl_loaddata(_value, fg_g);
                if (!_name.strcmp("fg_b"))
                    lcl_loaddata(_value, fg_b);
                if (!_name.strcmp("pulse"))
                    lcl_loaddata(_value, pulse);

            }
            else
                break;
        }
    }


};

extern const ATTR_DEF glb_attrdefs[];

struct MAPFLAG_DEF
{


    void reset()
    {

    }

    void saveData(ostream &os) const
    {

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);

            }
            else
                break;
        }
    }


};

extern const MAPFLAG_DEF glb_mapflagdefs[];

struct EVENTTYPE_DEF
{


    void reset()
    {

    }

    void saveData(ostream &os) const
    {

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);

            }
            else
                break;
        }
    }


};

extern const EVENTTYPE_DEF glb_eventtypedefs[];

struct TILE_DEF
{
    u8 symbol;
    ATTR_NAMES attr;
    const char * legend;
    bool ispassable;
    bool istransparent;
    bool isphaseable;
    bool isdiggable;
    bool describe;
    bool semitransparent;
    bool forbidrandomwander;
    bool roomcolor;
    bool roomsymbol;
    bool isdoorway;


    void reset()
    {
        symbol = '&';
        attr = ATTR_NORMAL;
        legend = "none";
        ispassable = true;
        istransparent = true;
        isphaseable = true;
        isdiggable = false;
        describe = false;
        semitransparent = false;
        forbidrandomwander = false;
        roomcolor = false;
        roomsymbol = false;
        isdoorway = false;

    }

    void saveData(ostream &os) const
    {
        os << "    symbol " << lcl_savedata(symbol).buffer() << "\n";
        os << "    attr " << lcl_savedata((int)attr).buffer() << "\n";
        os << "    legend " << lcl_savedata(legend).buffer() << "\n";
        os << "    ispassable " << lcl_savedata(ispassable).buffer() << "\n";
        os << "    istransparent " << lcl_savedata(istransparent).buffer() << "\n";
        os << "    isphaseable " << lcl_savedata(isphaseable).buffer() << "\n";
        os << "    isdiggable " << lcl_savedata(isdiggable).buffer() << "\n";
        os << "    describe " << lcl_savedata(describe).buffer() << "\n";
        os << "    semitransparent " << lcl_savedata(semitransparent).buffer() << "\n";
        os << "    forbidrandomwander " << lcl_savedata(forbidrandomwander).buffer() << "\n";
        os << "    roomcolor " << lcl_savedata(roomcolor).buffer() << "\n";
        os << "    roomsymbol " << lcl_savedata(roomsymbol).buffer() << "\n";
        os << "    isdoorway " << lcl_savedata(isdoorway).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("symbol"))
                    lcl_loaddata(_value, symbol);
                if (!_name.strcmp("attr"))
                    { int tmp; lcl_loaddata(_value, tmp); attr = (ATTR_NAMES) tmp; }
                if (!_name.strcmp("legend"))
                    lcl_loaddata(_value, legend);
                if (!_name.strcmp("ispassable"))
                    lcl_loaddata(_value, ispassable);
                if (!_name.strcmp("istransparent"))
                    lcl_loaddata(_value, istransparent);
                if (!_name.strcmp("isphaseable"))
                    lcl_loaddata(_value, isphaseable);
                if (!_name.strcmp("isdiggable"))
                    lcl_loaddata(_value, isdiggable);
                if (!_name.strcmp("describe"))
                    lcl_loaddata(_value, describe);
                if (!_name.strcmp("semitransparent"))
                    lcl_loaddata(_value, semitransparent);
                if (!_name.strcmp("forbidrandomwander"))
                    lcl_loaddata(_value, forbidrandomwander);
                if (!_name.strcmp("roomcolor"))
                    lcl_loaddata(_value, roomcolor);
                if (!_name.strcmp("roomsymbol"))
                    lcl_loaddata(_value, roomsymbol);
                if (!_name.strcmp("isdoorway"))
                    lcl_loaddata(_value, isdoorway);

            }
            else
                break;
        }
    }


};

extern const TILE_DEF glb_tiledefs[];

struct TERRAIN_DEF
{
    TILE_NAMES tile;
    u8 grass;
    u8 dirt;
    u8 bush;
    u8 tree;
    int sightrange;
    int armyrange;


    void reset()
    {
        tile = TILE_NONE;
        grass = 0;
        dirt = 0;
        bush = 0;
        tree = 0;
        sightrange = 30;
        armyrange = 500;

    }

    void saveData(ostream &os) const
    {
        os << "    tile " << lcl_savedata((int)tile).buffer() << "\n";
        os << "    grass " << lcl_savedata(grass).buffer() << "\n";
        os << "    dirt " << lcl_savedata(dirt).buffer() << "\n";
        os << "    bush " << lcl_savedata(bush).buffer() << "\n";
        os << "    tree " << lcl_savedata(tree).buffer() << "\n";
        os << "    sightrange " << lcl_savedata(sightrange).buffer() << "\n";
        os << "    armyrange " << lcl_savedata(armyrange).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("tile"))
                    { int tmp; lcl_loaddata(_value, tmp); tile = (TILE_NAMES) tmp; }
                if (!_name.strcmp("grass"))
                    lcl_loaddata(_value, grass);
                if (!_name.strcmp("dirt"))
                    lcl_loaddata(_value, dirt);
                if (!_name.strcmp("bush"))
                    lcl_loaddata(_value, bush);
                if (!_name.strcmp("tree"))
                    lcl_loaddata(_value, tree);
                if (!_name.strcmp("sightrange"))
                    lcl_loaddata(_value, sightrange);
                if (!_name.strcmp("armyrange"))
                    lcl_loaddata(_value, armyrange);

            }
            else
                break;
        }
    }


};

extern const TERRAIN_DEF glb_terraindefs[];

struct AI_DEF
{
    const char * name;
    const char * descr;


    void reset()
    {
        name = "brainless";
        descr = "They are known to wander aimlessly about.";

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    descr " << lcl_savedata(descr).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("descr"))
                    lcl_loaddata(_value, descr);

            }
            else
                break;
        }
    }


};

extern const AI_DEF glb_aidefs[];

struct DISTRIBUTION_DEF
{
    const char * name;
    const char * descr;


    void reset()
    {
        name = "none";
        descr = "none";

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    descr " << lcl_savedata(descr).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("descr"))
                    lcl_loaddata(_value, descr);

            }
            else
                break;
        }
    }


};

extern const DISTRIBUTION_DEF glb_distributiondefs[];

struct ATTACK_DEF
{
    const char * verb;
    const char * noun;
    const char * fireball;
    EFFECT_NAMES effect;
    ELEMENT_NAMES element;
    DAMAGECLASS_NAMES damageclass;
    DICE damage;
    int chancebonus;


    void reset()
    {
        verb = "attack";
        noun = "attack";
        fireball = "cloud of daggers appears";
        effect = EFFECT_NONE;
        element = ELEMENT_PHYSICAL;
        damageclass = DAMAGECLASS_NONE;
        damage = DICE{ 0, 0, 0 };
        chancebonus = 0;

    }

    void saveData(ostream &os) const
    {
        os << "    verb " << lcl_savedata(verb).buffer() << "\n";
        os << "    noun " << lcl_savedata(noun).buffer() << "\n";
        os << "    fireball " << lcl_savedata(fireball).buffer() << "\n";
        os << "    effect " << lcl_savedata((int)effect).buffer() << "\n";
        os << "    element " << lcl_savedata((int)element).buffer() << "\n";
        os << "    damageclass " << lcl_savedata((int)damageclass).buffer() << "\n";
        os << "    damage " << lcl_savedata(damage).buffer() << "\n";
        os << "    chancebonus " << lcl_savedata(chancebonus).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("verb"))
                    lcl_loaddata(_value, verb);
                if (!_name.strcmp("noun"))
                    lcl_loaddata(_value, noun);
                if (!_name.strcmp("fireball"))
                    lcl_loaddata(_value, fireball);
                if (!_name.strcmp("effect"))
                    { int tmp; lcl_loaddata(_value, tmp); effect = (EFFECT_NAMES) tmp; }
                if (!_name.strcmp("element"))
                    { int tmp; lcl_loaddata(_value, tmp); element = (ELEMENT_NAMES) tmp; }
                if (!_name.strcmp("damageclass"))
                    { int tmp; lcl_loaddata(_value, tmp); damageclass = (DAMAGECLASS_NAMES) tmp; }
                if (!_name.strcmp("damage"))
                    lcl_loaddata(_value, damage);
                if (!_name.strcmp("chancebonus"))
                    lcl_loaddata(_value, chancebonus);

            }
            else
                break;
        }
    }


};

extern const ATTACK_DEF glb_attackdefs[];

struct ITEMLIST_DEF
{
    ITEM_NAMES item;
    ITEMCLASS_NAMES itemclass;
    int chance;
    DICE count;
    ITEMLIST_NAMES next;


    void reset()
    {
        item = ITEM_NONE;
        itemclass = ITEMCLASS_NONE;
        chance = 100;
        count = DICE{ 0, 0, 1 };
        next = ITEMLIST_NONE;

    }

    void saveData(ostream &os) const
    {
        os << "    item " << lcl_savedata((int)item).buffer() << "\n";
        os << "    itemclass " << lcl_savedata((int)itemclass).buffer() << "\n";
        os << "    chance " << lcl_savedata(chance).buffer() << "\n";
        os << "    count " << lcl_savedata(count).buffer() << "\n";
        os << "    next " << lcl_savedata((int)next).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("item"))
                    { int tmp; lcl_loaddata(_value, tmp); item = (ITEM_NAMES) tmp; }
                if (!_name.strcmp("itemclass"))
                    { int tmp; lcl_loaddata(_value, tmp); itemclass = (ITEMCLASS_NAMES) tmp; }
                if (!_name.strcmp("chance"))
                    lcl_loaddata(_value, chance);
                if (!_name.strcmp("count"))
                    lcl_loaddata(_value, count);
                if (!_name.strcmp("next"))
                    { int tmp; lcl_loaddata(_value, tmp); next = (ITEMLIST_NAMES) tmp; }

            }
            else
                break;
        }
    }


};

extern const ITEMLIST_DEF glb_itemlistdefs[];

struct STARTITEMS_DEF
{
    ITEMLIST_NAMES itemlist;
    int rarity;
    STARTITEMS_NAMES next;


    void reset()
    {
        itemlist = ITEMLIST_NONE;
        rarity = 100;
        next = STARTITEMS_NONE;

    }

    void saveData(ostream &os) const
    {
        os << "    itemlist " << lcl_savedata((int)itemlist).buffer() << "\n";
        os << "    rarity " << lcl_savedata(rarity).buffer() << "\n";
        os << "    next " << lcl_savedata((int)next).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("itemlist"))
                    { int tmp; lcl_loaddata(_value, tmp); itemlist = (ITEMLIST_NAMES) tmp; }
                if (!_name.strcmp("rarity"))
                    lcl_loaddata(_value, rarity);
                if (!_name.strcmp("next"))
                    { int tmp; lcl_loaddata(_value, tmp); next = (STARTITEMS_NAMES) tmp; }

            }
            else
                break;
        }
    }


};

extern const STARTITEMS_DEF glb_startitemsdefs[];

struct MOB_DEF
{
    u8 symbol;
    ATTR_NAMES attr;
    const char * name;
    const char * descr;
    bool isfriendly;
    bool isavatarform;
    ATTACK_NAMES melee_attack;
    WORLDLIST_NAMES worlds;
    ROLE_NAMES role;
    bool range_valid;
    ATTACK_NAMES range_attack;
    int range_range;
    int range_area;
    int range_recharge;
    u8 range_symbol;
    const char * range_announce;
    ATTR_NAMES range_attr;
    ITEM_NAMES range_ammo;
    DICE max_hp;
    int max_mp;
    DICE hp_gain;
    int damagereduction;
    int dodgebonus;
    int depth;
    int rarity;
    AI_NAMES ai;
    int corpsechance;
    EFFECT_NAMES corpse_effect;
    int loot;
    STARTITEMS_NAMES startitems;
    ELEMENT_NAMES vulnerability;
    ELEMENT_NAMES resistance;
    bool isslow;
    bool isfast;
    bool isvampire;
    bool canbreathe;
    bool hidefromlos;
    bool isregenerate;
    bool passwall;
    bool candig;
    bool opendoors;
    bool breakdoors;
    bool swallows;
    bool breeder;
    bool isthief;
    bool canleap;
    bool cansleep;
    int sightrange;
    bool corrosiveblood;
    bool isconstruct;
    bool useitems;
    bool covetous;
    int totalkillsever;
    SIZE_NAMES size;


    void reset()
    {
        symbol = '?';
        attr = ATTR_NORMAL;
        name = "unnamed";
        descr = "";
        isfriendly = false;
        isavatarform = false;
        melee_attack = ATTACK_NONE;
        worlds = WORLDLIST_FIGHTER;
        role = ROLE_NONE;
        range_valid = false;
        range_attack = ATTACK_NONE;
        range_range = 0;
        range_area = 1;
        range_recharge = 0;
        range_symbol = '*';
        range_announce = "%S <shoot>.";
        range_attr = ATTR_NORMAL;
        range_ammo = ITEM_NONE;
        max_hp = DICE{ 0, 0, 1 };
        max_mp = 0;
        hp_gain = DICE{ 1, 4, 4 };
        damagereduction = 0;
        dodgebonus = 0;
        depth = 0;
        rarity = 100;
        ai = AI_CHARGE;
        corpsechance = 30;
        corpse_effect = EFFECT_NONE;
        loot = -1;
        startitems = STARTITEMS_NONE;
        vulnerability = ELEMENT_NONE;
        resistance = ELEMENT_NONE;
        isslow = false;
        isfast = false;
        isvampire = false;
        canbreathe = true;
        hidefromlos = false;
        isregenerate = false;
        passwall = false;
        candig = false;
        opendoors = false;
        breakdoors = false;
        swallows = false;
        breeder = false;
        isthief = false;
        canleap = false;
        cansleep = true;
        sightrange = 8;
        corrosiveblood = false;
        isconstruct = false;
        useitems = false;
        covetous = false;
        totalkillsever = 0;
        size = SIZE_SMALL;

    }

    void saveData(ostream &os) const
    {
        os << "    symbol " << lcl_savedata(symbol).buffer() << "\n";
        os << "    attr " << lcl_savedata((int)attr).buffer() << "\n";
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    descr " << lcl_savedata(descr).buffer() << "\n";
        os << "    isfriendly " << lcl_savedata(isfriendly).buffer() << "\n";
        os << "    isavatarform " << lcl_savedata(isavatarform).buffer() << "\n";
        os << "    melee_attack " << lcl_savedata((int)melee_attack).buffer() << "\n";
        os << "    worlds " << lcl_savedata((int)worlds).buffer() << "\n";
        os << "    role " << lcl_savedata((int)role).buffer() << "\n";
        os << "    range_valid " << lcl_savedata(range_valid).buffer() << "\n";
        os << "    range_attack " << lcl_savedata((int)range_attack).buffer() << "\n";
        os << "    range_range " << lcl_savedata(range_range).buffer() << "\n";
        os << "    range_area " << lcl_savedata(range_area).buffer() << "\n";
        os << "    range_recharge " << lcl_savedata(range_recharge).buffer() << "\n";
        os << "    range_symbol " << lcl_savedata(range_symbol).buffer() << "\n";
        os << "    range_announce " << lcl_savedata(range_announce).buffer() << "\n";
        os << "    range_attr " << lcl_savedata((int)range_attr).buffer() << "\n";
        os << "    range_ammo " << lcl_savedata((int)range_ammo).buffer() << "\n";
        os << "    max_hp " << lcl_savedata(max_hp).buffer() << "\n";
        os << "    max_mp " << lcl_savedata(max_mp).buffer() << "\n";
        os << "    hp_gain " << lcl_savedata(hp_gain).buffer() << "\n";
        os << "    damagereduction " << lcl_savedata(damagereduction).buffer() << "\n";
        os << "    dodgebonus " << lcl_savedata(dodgebonus).buffer() << "\n";
        os << "    depth " << lcl_savedata(depth).buffer() << "\n";
        os << "    rarity " << lcl_savedata(rarity).buffer() << "\n";
        os << "    ai " << lcl_savedata((int)ai).buffer() << "\n";
        os << "    corpsechance " << lcl_savedata(corpsechance).buffer() << "\n";
        os << "    corpse_effect " << lcl_savedata((int)corpse_effect).buffer() << "\n";
        os << "    loot " << lcl_savedata(loot).buffer() << "\n";
        os << "    startitems " << lcl_savedata((int)startitems).buffer() << "\n";
        os << "    vulnerability " << lcl_savedata((int)vulnerability).buffer() << "\n";
        os << "    resistance " << lcl_savedata((int)resistance).buffer() << "\n";
        os << "    isslow " << lcl_savedata(isslow).buffer() << "\n";
        os << "    isfast " << lcl_savedata(isfast).buffer() << "\n";
        os << "    isvampire " << lcl_savedata(isvampire).buffer() << "\n";
        os << "    canbreathe " << lcl_savedata(canbreathe).buffer() << "\n";
        os << "    hidefromlos " << lcl_savedata(hidefromlos).buffer() << "\n";
        os << "    isregenerate " << lcl_savedata(isregenerate).buffer() << "\n";
        os << "    passwall " << lcl_savedata(passwall).buffer() << "\n";
        os << "    candig " << lcl_savedata(candig).buffer() << "\n";
        os << "    opendoors " << lcl_savedata(opendoors).buffer() << "\n";
        os << "    breakdoors " << lcl_savedata(breakdoors).buffer() << "\n";
        os << "    swallows " << lcl_savedata(swallows).buffer() << "\n";
        os << "    breeder " << lcl_savedata(breeder).buffer() << "\n";
        os << "    isthief " << lcl_savedata(isthief).buffer() << "\n";
        os << "    canleap " << lcl_savedata(canleap).buffer() << "\n";
        os << "    cansleep " << lcl_savedata(cansleep).buffer() << "\n";
        os << "    sightrange " << lcl_savedata(sightrange).buffer() << "\n";
        os << "    corrosiveblood " << lcl_savedata(corrosiveblood).buffer() << "\n";
        os << "    isconstruct " << lcl_savedata(isconstruct).buffer() << "\n";
        os << "    useitems " << lcl_savedata(useitems).buffer() << "\n";
        os << "    covetous " << lcl_savedata(covetous).buffer() << "\n";
        os << "    totalkillsever " << lcl_savedata(totalkillsever).buffer() << "\n";
        os << "    size " << lcl_savedata((int)size).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("symbol"))
                    lcl_loaddata(_value, symbol);
                if (!_name.strcmp("attr"))
                    { int tmp; lcl_loaddata(_value, tmp); attr = (ATTR_NAMES) tmp; }
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("descr"))
                    lcl_loaddata(_value, descr);
                if (!_name.strcmp("isfriendly"))
                    lcl_loaddata(_value, isfriendly);
                if (!_name.strcmp("isavatarform"))
                    lcl_loaddata(_value, isavatarform);
                if (!_name.strcmp("melee_attack"))
                    { int tmp; lcl_loaddata(_value, tmp); melee_attack = (ATTACK_NAMES) tmp; }
                if (!_name.strcmp("worlds"))
                    { int tmp; lcl_loaddata(_value, tmp); worlds = (WORLDLIST_NAMES) tmp; }
                if (!_name.strcmp("role"))
                    { int tmp; lcl_loaddata(_value, tmp); role = (ROLE_NAMES) tmp; }
                if (!_name.strcmp("range_valid"))
                    lcl_loaddata(_value, range_valid);
                if (!_name.strcmp("range_attack"))
                    { int tmp; lcl_loaddata(_value, tmp); range_attack = (ATTACK_NAMES) tmp; }
                if (!_name.strcmp("range_range"))
                    lcl_loaddata(_value, range_range);
                if (!_name.strcmp("range_area"))
                    lcl_loaddata(_value, range_area);
                if (!_name.strcmp("range_recharge"))
                    lcl_loaddata(_value, range_recharge);
                if (!_name.strcmp("range_symbol"))
                    lcl_loaddata(_value, range_symbol);
                if (!_name.strcmp("range_announce"))
                    lcl_loaddata(_value, range_announce);
                if (!_name.strcmp("range_attr"))
                    { int tmp; lcl_loaddata(_value, tmp); range_attr = (ATTR_NAMES) tmp; }
                if (!_name.strcmp("range_ammo"))
                    { int tmp; lcl_loaddata(_value, tmp); range_ammo = (ITEM_NAMES) tmp; }
                if (!_name.strcmp("max_hp"))
                    lcl_loaddata(_value, max_hp);
                if (!_name.strcmp("max_mp"))
                    lcl_loaddata(_value, max_mp);
                if (!_name.strcmp("hp_gain"))
                    lcl_loaddata(_value, hp_gain);
                if (!_name.strcmp("damagereduction"))
                    lcl_loaddata(_value, damagereduction);
                if (!_name.strcmp("dodgebonus"))
                    lcl_loaddata(_value, dodgebonus);
                if (!_name.strcmp("depth"))
                    lcl_loaddata(_value, depth);
                if (!_name.strcmp("rarity"))
                    lcl_loaddata(_value, rarity);
                if (!_name.strcmp("ai"))
                    { int tmp; lcl_loaddata(_value, tmp); ai = (AI_NAMES) tmp; }
                if (!_name.strcmp("corpsechance"))
                    lcl_loaddata(_value, corpsechance);
                if (!_name.strcmp("corpse_effect"))
                    { int tmp; lcl_loaddata(_value, tmp); corpse_effect = (EFFECT_NAMES) tmp; }
                if (!_name.strcmp("loot"))
                    lcl_loaddata(_value, loot);
                if (!_name.strcmp("startitems"))
                    { int tmp; lcl_loaddata(_value, tmp); startitems = (STARTITEMS_NAMES) tmp; }
                if (!_name.strcmp("vulnerability"))
                    { int tmp; lcl_loaddata(_value, tmp); vulnerability = (ELEMENT_NAMES) tmp; }
                if (!_name.strcmp("resistance"))
                    { int tmp; lcl_loaddata(_value, tmp); resistance = (ELEMENT_NAMES) tmp; }
                if (!_name.strcmp("isslow"))
                    lcl_loaddata(_value, isslow);
                if (!_name.strcmp("isfast"))
                    lcl_loaddata(_value, isfast);
                if (!_name.strcmp("isvampire"))
                    lcl_loaddata(_value, isvampire);
                if (!_name.strcmp("canbreathe"))
                    lcl_loaddata(_value, canbreathe);
                if (!_name.strcmp("hidefromlos"))
                    lcl_loaddata(_value, hidefromlos);
                if (!_name.strcmp("isregenerate"))
                    lcl_loaddata(_value, isregenerate);
                if (!_name.strcmp("passwall"))
                    lcl_loaddata(_value, passwall);
                if (!_name.strcmp("candig"))
                    lcl_loaddata(_value, candig);
                if (!_name.strcmp("opendoors"))
                    lcl_loaddata(_value, opendoors);
                if (!_name.strcmp("breakdoors"))
                    lcl_loaddata(_value, breakdoors);
                if (!_name.strcmp("swallows"))
                    lcl_loaddata(_value, swallows);
                if (!_name.strcmp("breeder"))
                    lcl_loaddata(_value, breeder);
                if (!_name.strcmp("isthief"))
                    lcl_loaddata(_value, isthief);
                if (!_name.strcmp("canleap"))
                    lcl_loaddata(_value, canleap);
                if (!_name.strcmp("cansleep"))
                    lcl_loaddata(_value, cansleep);
                if (!_name.strcmp("sightrange"))
                    lcl_loaddata(_value, sightrange);
                if (!_name.strcmp("corrosiveblood"))
                    lcl_loaddata(_value, corrosiveblood);
                if (!_name.strcmp("isconstruct"))
                    lcl_loaddata(_value, isconstruct);
                if (!_name.strcmp("useitems"))
                    lcl_loaddata(_value, useitems);
                if (!_name.strcmp("covetous"))
                    lcl_loaddata(_value, covetous);
                if (!_name.strcmp("totalkillsever"))
                    lcl_loaddata(_value, totalkillsever);
                if (!_name.strcmp("size"))
                    { int tmp; lcl_loaddata(_value, tmp); size = (SIZE_NAMES) tmp; }

            }
            else
                break;
        }
    }


};

extern const MOB_DEF glb_mobdefs[];

struct ARMOURSLOT_DEF
{
    const char * name;
    int coverage;


    void reset()
    {
        name = "body";
        coverage = 50;

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    coverage " << lcl_savedata(coverage).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("coverage"))
                    lcl_loaddata(_value, coverage);

            }
            else
                break;
        }
    }


};

extern const ARMOURSLOT_DEF glb_armourslotdefs[];

struct ITEMCLASS_DEF
{
    const char * name;
    u8 symbol;
    int rarity;


    void reset()
    {
        name = "no class";
        symbol = '~';
        rarity = 100;

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    symbol " << lcl_savedata(symbol).buffer() << "\n";
        os << "    rarity " << lcl_savedata(rarity).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("symbol"))
                    lcl_loaddata(_value, symbol);
                if (!_name.strcmp("rarity"))
                    lcl_loaddata(_value, rarity);

            }
            else
                break;
        }
    }


};

extern const ITEMCLASS_DEF glb_itemclassdefs[];

struct ITEM_DEF
{
    const char * name;
    int timer;
    int rarity;
    int depth;
    bool thesaurus;
    WORLDLIST_NAMES worlds;
    ROLELIST_NAMES roles;
    bool isflag;
    u8 symbol;
    ATTR_NAMES attr;
    bool exclusive;
    bool needsmaterial;
    bool gildable;
    int mass;
    int foodval;
    SIZE_NAMES size;
    ITEMCLASS_NAMES itemclass;
    const char * gaintxt;
    const char * losetxt;
    bool needtarget;
    bool unstackable;
    DICE startstack;
    ATTACK_NAMES melee_attack;
    int damagereduction;
    int ac_slash;
    int ac_blunt;
    int ac_pierce;
    int ac_splash;
    int ac_dodge;
    ARMOURSLOT_NAMES armourslot;
    int noise;
    int range_range;
    ATTACK_NAMES range_attack;
    int range_area;
    const char * range_announce;
    u8 range_symbol;
    ATTR_NAMES range_attr;
    ITEM_NAMES ammo;
    bool startsbroken;
    int breakchance;
    bool discardextra;
    bool throwable;


    void reset()
    {
        name = "unnamed";
        timer = -1;
        rarity = 100;
        depth = 0;
        thesaurus = false;
        worlds = WORLDLIST_ALL;
        roles = ROLELIST_ALL;
        isflag = false;
        symbol = '&';
        attr = ATTR_CYAN;
        exclusive = false;
        needsmaterial = false;
        gildable = false;
        mass = 1;
        foodval = 0;
        size = SIZE_TINY;
        itemclass = ITEMCLASS_NONE;
        gaintxt = 0;
        losetxt = 0;
        needtarget = false;
        unstackable = false;
        startstack = DICE{ 0, 0, 1 };
        melee_attack = ATTACK_NONE;
        damagereduction = 0;
        ac_slash = 0;
        ac_blunt = 0;
        ac_pierce = 0;
        ac_splash = 0;
        ac_dodge = 0;
        armourslot = ARMOURSLOT_NONE;
        noise = 0;
        range_range = 0;
        range_attack = ATTACK_NONE;
        range_area = 1;
        range_announce = "%S <shoot>.";
        range_symbol = '*';
        range_attr = ATTR_NORMAL;
        ammo = ITEM_NONE;
        startsbroken = false;
        breakchance = 0;
        discardextra = false;
        throwable = false;

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    timer " << lcl_savedata(timer).buffer() << "\n";
        os << "    rarity " << lcl_savedata(rarity).buffer() << "\n";
        os << "    depth " << lcl_savedata(depth).buffer() << "\n";
        os << "    thesaurus " << lcl_savedata(thesaurus).buffer() << "\n";
        os << "    worlds " << lcl_savedata((int)worlds).buffer() << "\n";
        os << "    roles " << lcl_savedata((int)roles).buffer() << "\n";
        os << "    isflag " << lcl_savedata(isflag).buffer() << "\n";
        os << "    symbol " << lcl_savedata(symbol).buffer() << "\n";
        os << "    attr " << lcl_savedata((int)attr).buffer() << "\n";
        os << "    exclusive " << lcl_savedata(exclusive).buffer() << "\n";
        os << "    needsmaterial " << lcl_savedata(needsmaterial).buffer() << "\n";
        os << "    gildable " << lcl_savedata(gildable).buffer() << "\n";
        os << "    mass " << lcl_savedata(mass).buffer() << "\n";
        os << "    foodval " << lcl_savedata(foodval).buffer() << "\n";
        os << "    size " << lcl_savedata((int)size).buffer() << "\n";
        os << "    itemclass " << lcl_savedata((int)itemclass).buffer() << "\n";
        os << "    gaintxt " << lcl_savedata(gaintxt).buffer() << "\n";
        os << "    losetxt " << lcl_savedata(losetxt).buffer() << "\n";
        os << "    needtarget " << lcl_savedata(needtarget).buffer() << "\n";
        os << "    unstackable " << lcl_savedata(unstackable).buffer() << "\n";
        os << "    startstack " << lcl_savedata(startstack).buffer() << "\n";
        os << "    melee_attack " << lcl_savedata((int)melee_attack).buffer() << "\n";
        os << "    damagereduction " << lcl_savedata(damagereduction).buffer() << "\n";
        os << "    ac_slash " << lcl_savedata(ac_slash).buffer() << "\n";
        os << "    ac_blunt " << lcl_savedata(ac_blunt).buffer() << "\n";
        os << "    ac_pierce " << lcl_savedata(ac_pierce).buffer() << "\n";
        os << "    ac_splash " << lcl_savedata(ac_splash).buffer() << "\n";
        os << "    ac_dodge " << lcl_savedata(ac_dodge).buffer() << "\n";
        os << "    armourslot " << lcl_savedata((int)armourslot).buffer() << "\n";
        os << "    noise " << lcl_savedata(noise).buffer() << "\n";
        os << "    range_range " << lcl_savedata(range_range).buffer() << "\n";
        os << "    range_attack " << lcl_savedata((int)range_attack).buffer() << "\n";
        os << "    range_area " << lcl_savedata(range_area).buffer() << "\n";
        os << "    range_announce " << lcl_savedata(range_announce).buffer() << "\n";
        os << "    range_symbol " << lcl_savedata(range_symbol).buffer() << "\n";
        os << "    range_attr " << lcl_savedata((int)range_attr).buffer() << "\n";
        os << "    ammo " << lcl_savedata((int)ammo).buffer() << "\n";
        os << "    startsbroken " << lcl_savedata(startsbroken).buffer() << "\n";
        os << "    breakchance " << lcl_savedata(breakchance).buffer() << "\n";
        os << "    discardextra " << lcl_savedata(discardextra).buffer() << "\n";
        os << "    throwable " << lcl_savedata(throwable).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("timer"))
                    lcl_loaddata(_value, timer);
                if (!_name.strcmp("rarity"))
                    lcl_loaddata(_value, rarity);
                if (!_name.strcmp("depth"))
                    lcl_loaddata(_value, depth);
                if (!_name.strcmp("thesaurus"))
                    lcl_loaddata(_value, thesaurus);
                if (!_name.strcmp("worlds"))
                    { int tmp; lcl_loaddata(_value, tmp); worlds = (WORLDLIST_NAMES) tmp; }
                if (!_name.strcmp("roles"))
                    { int tmp; lcl_loaddata(_value, tmp); roles = (ROLELIST_NAMES) tmp; }
                if (!_name.strcmp("isflag"))
                    lcl_loaddata(_value, isflag);
                if (!_name.strcmp("symbol"))
                    lcl_loaddata(_value, symbol);
                if (!_name.strcmp("attr"))
                    { int tmp; lcl_loaddata(_value, tmp); attr = (ATTR_NAMES) tmp; }
                if (!_name.strcmp("exclusive"))
                    lcl_loaddata(_value, exclusive);
                if (!_name.strcmp("needsmaterial"))
                    lcl_loaddata(_value, needsmaterial);
                if (!_name.strcmp("gildable"))
                    lcl_loaddata(_value, gildable);
                if (!_name.strcmp("mass"))
                    lcl_loaddata(_value, mass);
                if (!_name.strcmp("foodval"))
                    lcl_loaddata(_value, foodval);
                if (!_name.strcmp("size"))
                    { int tmp; lcl_loaddata(_value, tmp); size = (SIZE_NAMES) tmp; }
                if (!_name.strcmp("itemclass"))
                    { int tmp; lcl_loaddata(_value, tmp); itemclass = (ITEMCLASS_NAMES) tmp; }
                if (!_name.strcmp("gaintxt"))
                    lcl_loaddata(_value, gaintxt);
                if (!_name.strcmp("losetxt"))
                    lcl_loaddata(_value, losetxt);
                if (!_name.strcmp("needtarget"))
                    lcl_loaddata(_value, needtarget);
                if (!_name.strcmp("unstackable"))
                    lcl_loaddata(_value, unstackable);
                if (!_name.strcmp("startstack"))
                    lcl_loaddata(_value, startstack);
                if (!_name.strcmp("melee_attack"))
                    { int tmp; lcl_loaddata(_value, tmp); melee_attack = (ATTACK_NAMES) tmp; }
                if (!_name.strcmp("damagereduction"))
                    lcl_loaddata(_value, damagereduction);
                if (!_name.strcmp("ac_slash"))
                    lcl_loaddata(_value, ac_slash);
                if (!_name.strcmp("ac_blunt"))
                    lcl_loaddata(_value, ac_blunt);
                if (!_name.strcmp("ac_pierce"))
                    lcl_loaddata(_value, ac_pierce);
                if (!_name.strcmp("ac_splash"))
                    lcl_loaddata(_value, ac_splash);
                if (!_name.strcmp("ac_dodge"))
                    lcl_loaddata(_value, ac_dodge);
                if (!_name.strcmp("armourslot"))
                    { int tmp; lcl_loaddata(_value, tmp); armourslot = (ARMOURSLOT_NAMES) tmp; }
                if (!_name.strcmp("noise"))
                    lcl_loaddata(_value, noise);
                if (!_name.strcmp("range_range"))
                    lcl_loaddata(_value, range_range);
                if (!_name.strcmp("range_attack"))
                    { int tmp; lcl_loaddata(_value, tmp); range_attack = (ATTACK_NAMES) tmp; }
                if (!_name.strcmp("range_area"))
                    lcl_loaddata(_value, range_area);
                if (!_name.strcmp("range_announce"))
                    lcl_loaddata(_value, range_announce);
                if (!_name.strcmp("range_symbol"))
                    lcl_loaddata(_value, range_symbol);
                if (!_name.strcmp("range_attr"))
                    { int tmp; lcl_loaddata(_value, tmp); range_attr = (ATTR_NAMES) tmp; }
                if (!_name.strcmp("ammo"))
                    { int tmp; lcl_loaddata(_value, tmp); ammo = (ITEM_NAMES) tmp; }
                if (!_name.strcmp("startsbroken"))
                    lcl_loaddata(_value, startsbroken);
                if (!_name.strcmp("breakchance"))
                    lcl_loaddata(_value, breakchance);
                if (!_name.strcmp("discardextra"))
                    lcl_loaddata(_value, discardextra);
                if (!_name.strcmp("throwable"))
                    lcl_loaddata(_value, throwable);

            }
            else
                break;
        }
    }


};

extern const ITEM_DEF glb_itemdefs[];

struct SCROLL_DEF
{
    const char * name;


    void reset()
    {
        name = "blank";

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);

            }
            else
                break;
        }
    }


};

extern const SCROLL_DEF glb_scrolldefs[];

struct SPELL_DEF
{
    const char * name;
    const char * verb;
    const char * fireball;
    const char * runes;
    const char * descr;
    u8 symbol;
    ATTR_NAMES attr;
    int difficulty;
    int mana;
    bool reqfullmana;
    int timeout;
    bool needsdir;
    bool piercing;
    bool friendlyfire;
    int radius;
    int range;
    bool blast;
    bool cone;
    EFFECT_NAMES effect;
    ITEM_NAMES item;


    void reset()
    {
        name = "unnamed";
        verb = "zap";
        fireball = "burst of magic appears";
        runes = "~~~";
        descr = "Does nothing.";
        symbol = '*';
        attr = ATTR_FIRE;
        difficulty = 1;
        mana = 0;
        reqfullmana = false;
        timeout = 0;
        needsdir = true;
        piercing = false;
        friendlyfire = false;
        radius = 1;
        range = 10;
        blast = false;
        cone = false;
        effect = EFFECT_NONE;
        item = ITEM_NONE;

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    verb " << lcl_savedata(verb).buffer() << "\n";
        os << "    fireball " << lcl_savedata(fireball).buffer() << "\n";
        os << "    runes " << lcl_savedata(runes).buffer() << "\n";
        os << "    descr " << lcl_savedata(descr).buffer() << "\n";
        os << "    symbol " << lcl_savedata(symbol).buffer() << "\n";
        os << "    attr " << lcl_savedata((int)attr).buffer() << "\n";
        os << "    difficulty " << lcl_savedata(difficulty).buffer() << "\n";
        os << "    mana " << lcl_savedata(mana).buffer() << "\n";
        os << "    reqfullmana " << lcl_savedata(reqfullmana).buffer() << "\n";
        os << "    timeout " << lcl_savedata(timeout).buffer() << "\n";
        os << "    needsdir " << lcl_savedata(needsdir).buffer() << "\n";
        os << "    piercing " << lcl_savedata(piercing).buffer() << "\n";
        os << "    friendlyfire " << lcl_savedata(friendlyfire).buffer() << "\n";
        os << "    radius " << lcl_savedata(radius).buffer() << "\n";
        os << "    range " << lcl_savedata(range).buffer() << "\n";
        os << "    blast " << lcl_savedata(blast).buffer() << "\n";
        os << "    cone " << lcl_savedata(cone).buffer() << "\n";
        os << "    effect " << lcl_savedata((int)effect).buffer() << "\n";
        os << "    item " << lcl_savedata((int)item).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("verb"))
                    lcl_loaddata(_value, verb);
                if (!_name.strcmp("fireball"))
                    lcl_loaddata(_value, fireball);
                if (!_name.strcmp("runes"))
                    lcl_loaddata(_value, runes);
                if (!_name.strcmp("descr"))
                    lcl_loaddata(_value, descr);
                if (!_name.strcmp("symbol"))
                    lcl_loaddata(_value, symbol);
                if (!_name.strcmp("attr"))
                    { int tmp; lcl_loaddata(_value, tmp); attr = (ATTR_NAMES) tmp; }
                if (!_name.strcmp("difficulty"))
                    lcl_loaddata(_value, difficulty);
                if (!_name.strcmp("mana"))
                    lcl_loaddata(_value, mana);
                if (!_name.strcmp("reqfullmana"))
                    lcl_loaddata(_value, reqfullmana);
                if (!_name.strcmp("timeout"))
                    lcl_loaddata(_value, timeout);
                if (!_name.strcmp("needsdir"))
                    lcl_loaddata(_value, needsdir);
                if (!_name.strcmp("piercing"))
                    lcl_loaddata(_value, piercing);
                if (!_name.strcmp("friendlyfire"))
                    lcl_loaddata(_value, friendlyfire);
                if (!_name.strcmp("radius"))
                    lcl_loaddata(_value, radius);
                if (!_name.strcmp("range"))
                    lcl_loaddata(_value, range);
                if (!_name.strcmp("blast"))
                    lcl_loaddata(_value, blast);
                if (!_name.strcmp("cone"))
                    lcl_loaddata(_value, cone);
                if (!_name.strcmp("effect"))
                    { int tmp; lcl_loaddata(_value, tmp); effect = (EFFECT_NAMES) tmp; }
                if (!_name.strcmp("item"))
                    { int tmp; lcl_loaddata(_value, tmp); item = (ITEM_NAMES) tmp; }

            }
            else
                break;
        }
    }


};

extern const SPELL_DEF glb_spelldefs[];

struct RING_DEF
{
    const char * name;
    ELEMENT_NAMES resist;
    int resist_amt;
    int deflect;


    void reset()
    {
        name = "none";
        resist = ELEMENT_NONE;
        resist_amt = 0;
        deflect = 0;

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    resist " << lcl_savedata((int)resist).buffer() << "\n";
        os << "    resist_amt " << lcl_savedata(resist_amt).buffer() << "\n";
        os << "    deflect " << lcl_savedata(deflect).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("resist"))
                    { int tmp; lcl_loaddata(_value, tmp); resist = (ELEMENT_NAMES) tmp; }
                if (!_name.strcmp("resist_amt"))
                    lcl_loaddata(_value, resist_amt);
                if (!_name.strcmp("deflect"))
                    lcl_loaddata(_value, deflect);

            }
            else
                break;
        }
    }


};

extern const RING_DEF glb_ringdefs[];

struct POTION_DEF
{
    const char * name;
    EFFECT_NAMES effect;


    void reset()
    {
        name = "none";
        effect = EFFECT_NONE;

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    effect " << lcl_savedata((int)effect).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("effect"))
                    { int tmp; lcl_loaddata(_value, tmp); effect = (EFFECT_NAMES) tmp; }

            }
            else
                break;
        }
    }


};

extern const POTION_DEF glb_potiondefs[];

struct MATERIAL_DEF
{
    const char * name;
    const char * adjname;
    bool gildable;
    int depth;
    ATTR_NAMES attr;
    bool burnable;
    bool corrodable;


    void reset()
    {
        name = "ether";
        adjname = "ether";
        gildable = false;
        depth = 0;
        attr = ATTR_WHITE;
        burnable = false;
        corrodable = false;

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    adjname " << lcl_savedata(adjname).buffer() << "\n";
        os << "    gildable " << lcl_savedata(gildable).buffer() << "\n";
        os << "    depth " << lcl_savedata(depth).buffer() << "\n";
        os << "    attr " << lcl_savedata((int)attr).buffer() << "\n";
        os << "    burnable " << lcl_savedata(burnable).buffer() << "\n";
        os << "    corrodable " << lcl_savedata(corrodable).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("adjname"))
                    lcl_loaddata(_value, adjname);
                if (!_name.strcmp("gildable"))
                    lcl_loaddata(_value, gildable);
                if (!_name.strcmp("depth"))
                    lcl_loaddata(_value, depth);
                if (!_name.strcmp("attr"))
                    { int tmp; lcl_loaddata(_value, tmp); attr = (ATTR_NAMES) tmp; }
                if (!_name.strcmp("burnable"))
                    lcl_loaddata(_value, burnable);
                if (!_name.strcmp("corrodable"))
                    lcl_loaddata(_value, corrodable);

            }
            else
                break;
        }
    }


};

extern const MATERIAL_DEF glb_materialdefs[];

struct TRAP_DEF
{
    const char * name;
    u8 sym;
    ATTR_NAMES attr;
    ATTACK_NAMES attack;


    void reset()
    {
        name = "unknown trap";
        sym = '^';
        attr = ATTR_NORMAL;
        attack = ATTACK_NONE;

    }

    void saveData(ostream &os) const
    {
        os << "    name " << lcl_savedata(name).buffer() << "\n";
        os << "    sym " << lcl_savedata(sym).buffer() << "\n";
        os << "    attr " << lcl_savedata((int)attr).buffer() << "\n";
        os << "    attack " << lcl_savedata((int)attack).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("name"))
                    lcl_loaddata(_value, name);
                if (!_name.strcmp("sym"))
                    lcl_loaddata(_value, sym);
                if (!_name.strcmp("attr"))
                    { int tmp; lcl_loaddata(_value, tmp); attr = (ATTR_NAMES) tmp; }
                if (!_name.strcmp("attack"))
                    { int tmp; lcl_loaddata(_value, tmp); attack = (ATTACK_NAMES) tmp; }

            }
            else
                break;
        }
    }


};

extern const TRAP_DEF glb_trapdefs[];

struct KEY_DEF
{
    u8 val;


    void reset()
    {
        val = ' ';

    }

    void saveData(ostream &os) const
    {
        os << "    val " << lcl_savedata(val).buffer() << "\n";

    }

    void loadData(istream &is)
    {
        reset();
        BUF     _name, _value;

        while (1)
        {
            _name = BUF::readtoken(is);
            if (_name.isstring() && _name.strcmp("}"))
            {
                _value = BUF::readtoken(is);
                if (!_name.strcmp("val"))
                    lcl_loaddata(_value, val);

            }
            else
                break;
        }
    }


};

extern const KEY_DEF glb_keydefs[];


#endif
