/*
 * PROPRIETARY INFORMATION.  This software is proprietary to POWDER
 * Development, and is not to be reproduced, transmitted, or disclosed
 * in any way without written permission.
 *
 * Produced by:	Jeff Lait
 *
 *      	POWDER Development
 *
 * NAME:        all_bitmaps.cpp ( gfx Library, C++ )
 *
 * COMMENTS:
 *		This file inlines all the auto-generated bitmap data,
 *		thereby reducing the compile time for gfxengine.cpp.
 */

#include "all_bitmaps.h"

// Include our raw graphics...
// This is done once for each tileset.

//
// Classic Tiles:
//

#define dungeon16_Tiles		dungeon16_classic_Tiles
#define alphabet_Tiles		alphabet_classic_Tiles
#define mini16_Tiles		mini16_classic_Tiles
#define sprite16_Tiles		sprite16_classic_Tiles
#define master_Palette		master_classic_Palette
#define sprite_Palette		sprite_classic_Palette
    #include "classic/dungeon16_16.c"
    #include "classic/alphabet_8.c"
    #include "classic/mini16_16.c"
    #include "classic/sprite16_16.c"
    #include "classic/sprite.pal.c"
    #include "classic/master.pal.c"
#undef dungeon16_Tiles
#undef alphabet_Tiles
#undef mini16_Tiles
#undef sprite16_Tiles
#undef master_Palette
#undef sprite_Palette

//
// Adam Bolt's Tiles:
//

#define dungeon16_Tiles		dungeon16_adambolt_Tiles
#define alphabet_Tiles		alphabet_adambolt_Tiles
#define mini16_Tiles		mini16_adambolt_Tiles
#define sprite16_Tiles		sprite16_adambolt_Tiles
#define sprite_Palette		sprite_adambolt_Palette
#define master_Palette		master_adambolt_Palette
    #include "adambolt/dungeon16_16.c"
    #include "adambolt/alphabet_8.c"
    #include "adambolt/mini16_16.c"
    #include "adambolt/sprite16_16.c"
    #include "adambolt/sprite.pal.c"
    #include "adambolt/master.pal.c"
#undef dungeon16_Tiles
#undef alphabet_Tiles
#undef mini16_Tiles
#undef sprite16_Tiles
#undef master_Palette
#undef sprite_Palette

//
// Nethack Tiles: (Thanks to Andrea Menga)
//

#define dungeon16_Tiles		dungeon16_nethack_Tiles
#define alphabet_Tiles		alphabet_nethack_Tiles
#define mini16_Tiles		mini16_nethack_Tiles
#define sprite16_Tiles		sprite16_nethack_Tiles
#define sprite_Palette		sprite_nethack_Palette
#define master_Palette		master_nethack_Palette
    #include "nethack/dungeon16_16.c"
    #include "nethack/alphabet_8.c"
    #include "nethack/mini16_16.c"
    #include "nethack/sprite16_16.c"
    #include "nethack/sprite.pal.c"
    #include "nethack/master.pal.c"
#undef dungeon16_Tiles
#undef alphabet_Tiles
#undef mini16_Tiles
#undef sprite16_Tiles
#undef sprite_Palette
#undef master_Palette

//
// ASCII's Tiles: (Thanks to Kelly Bailey)
//

#define dungeon16_Tiles		dungeon16_ascii_Tiles
#define alphabet_Tiles		alphabet_ascii_Tiles
#define mini16_Tiles		mini16_ascii_Tiles
#define sprite16_Tiles		sprite16_ascii_Tiles
#define sprite_Palette		sprite_ascii_Palette
#define master_Palette		master_ascii_Palette
    #include "ascii/dungeon16_16.c"
    #include "ascii/alphabet_8.c"
    #include "ascii/mini16_16.c"
    #include "ascii/sprite16_16.c"
    #include "ascii/sprite.pal.c"
    #include "ascii/master.pal.c"
#undef dungeon16_Tiles
#undef alphabet_Tiles
#undef mini16_Tiles
#undef sprite16_Tiles
#undef sprite_Palette
#undef master_Palette

//
// Akoi Meexx's Tiles: (Thanks to self-titled author)
//

#define dungeon16_Tiles		dungeon16_akoimeexx_Tiles
#define alphabet_Tiles		alphabet_akoimeexx_Tiles
#define mini16_Tiles		mini16_akoimeexx_Tiles
#define sprite16_Tiles		sprite16_akoimeexx_Tiles
#define sprite_Palette		sprite_akoimeexx_Palette
#define master_Palette		master_akoimeexx_Palette
    #include "akoimeexx/dungeon16_16.c"
    #include "akoimeexx/alphabet_8.c"
    #include "akoimeexx/mini16_16.c"
    #include "akoimeexx/sprite16_16.c"
    #include "akoimeexx/sprite.pal.c"
    #include "akoimeexx/master.pal.c"
#undef dungeon16_Tiles
#undef alphabet_Tiles
#undef mini16_Tiles
#undef sprite16_Tiles
#undef sprite_Palette
#undef master_Palette

//
// Full Screen Images:
//

#if defined(USING_DS) || defined(USING_SDL)

#define bmp_slug_and_blood_hires bmp_slug_and_blood_data
    #include "slug_and_blood_hires.bmp.c"
#undef bmp_slug_and_blood_hires
const unsigned short *bmp_slug_and_blood = bmp_slug_and_blood_data;

#else

#define bmp_slug_and_blood bmp_slug_and_blood_data
    #include "slug_and_blood.bmp.c"
#undef bmp_slug_and_blood
const unsigned short *bmp_slug_and_blood = bmp_slug_and_blood_data;

#endif

//
// Tileset linkage:
//	This is intentionaly not const so we can edit it with any
//	tilesets we find on disk.
//

TILESET glb_tilesetdata[NUM_TILESETS] =
{
    {
	alphabet_classic_Tiles,
	dungeon16_classic_Tiles,
	mini16_classic_Tiles,
	master_classic_Palette,
	sprite16_classic_Tiles,
	sprite_classic_Palette,
	"Classic"
    },
    {
	alphabet_adambolt_Tiles,
	dungeon16_adambolt_Tiles,
	mini16_adambolt_Tiles,
	master_adambolt_Palette,
	sprite16_adambolt_Tiles,
	sprite_adambolt_Palette,
	"Adam Bolt"
    },
    {
	alphabet_nethack_Tiles,
	dungeon16_nethack_Tiles,
	mini16_nethack_Tiles,
	master_nethack_Palette,
	sprite16_nethack_Tiles,
	sprite_nethack_Palette,
	"Nethackish"
    },
    {
	alphabet_ascii_Tiles,
	dungeon16_ascii_Tiles,
	mini16_ascii_Tiles,
	master_ascii_Palette,
	sprite16_ascii_Tiles,
	sprite_ascii_Palette,
	"Graphical ASCII"
    },
    {
	alphabet_akoimeexx_Tiles,
	dungeon16_akoimeexx_Tiles,
	mini16_akoimeexx_Tiles,
	master_akoimeexx_Palette,
	sprite16_akoimeexx_Tiles,
	sprite_akoimeexx_Palette,
	"Akoi Meexx"
    },
    {
	0,
	0,
	0,
	0,
	0,
	0,
	"From Disk"
    }
};

TILESET	*glb_tilesets = glb_tilesetdata;
